package cn.com.duiba.tuia.media.dao;

import java.util.List;

import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dataobject.ActivityManualPlanDO;

/**
 * ActivityManualPlanDAO
 */
public interface ActivityManualPlanDAO {

    /**
     * @param manualPlan
     * @return boolean
     */
    boolean insert(ActivityManualPlanDO manualPlan) throws TuiaMediaException ;

    /**
     * @param slotId
     * @return
     */
    List<ActivityManualPlanDO> selectForList(Long slotId) throws TuiaMediaException;

    /**
     * @param manualPlan
     * @return boolean
     */
    boolean update(ActivityManualPlanDO manualPlan) throws TuiaMediaException ;

    /**
     * @param manualPlan
     * @param status
     * @return boolean
     */
    boolean updateStatus(ActivityManualPlanDO manualPlan, int status) throws TuiaMediaException;
 
    /**
     * @param manualPlan
     * @param status
     * @return boolean
     */
    boolean updateStatusBefore(ActivityManualPlanDO manualPlan, int status) throws TuiaMediaException;

    /**
     * @param manualPlan
     * @return boolean
     * @throws TuiaMediaException
     */
    boolean delete(ActivityManualPlanDO manualPlan) throws TuiaMediaException;

    /**
     * @param slotId
     * @return
     * @throws TuiaMediaException
     */
    List<Long> selectSlotForList(Long activityId, Integer activityType) throws TuiaMediaException;
    
    /**
     * @param slotId
     * @return
     * @throws TuiaMediaException
     */
    List<Long> selectSlotForListBySource(Long activityId, Integer source) throws TuiaMediaException;
}
