package cn.com.duiba.tuia.media.dao;

import java.util.List;

import cn.com.duiba.tuia.media.api.dto.req.ReqActivitySlotDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspActivitySlotDto;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dataobject.ActivitySlotDO;

/**
 * @author xuyenan
 * @createTime 2016/12/20
 */
public interface ActivitySlotDAO {

    /**
     * insert
     * 
     * @param list
     * @return affect line
     */
    int insertBatch(List<ActivitySlotDO> list) throws TuiaMediaException;
    
    /**
     * 
     * insert. <br/>
     *
     * @param dto
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    
    int insertActivitySlot(ActivitySlotDO dto)throws TuiaMediaException;

    /**
     * delete
     * 
     * @param slotId
     * @return Boolean
     */
    int delete(Long slotId) throws TuiaMediaException;

    /**
     * getList
     *
     * @param req
     * @return 广告位列表
     */
    List<RspActivitySlotDto> getList(ReqActivitySlotDto req) throws TuiaMediaException;

    /**
     * getListAmount
     * 
     * @param req 条件
     * @return 数量
     */
    int getListAmount(ReqActivitySlotDto req) throws TuiaMediaException;

    /**
     * getBySlotId
     * 
     * @param slotId
     * @return 广告
     */
    ActivitySlotDO getBySlotId(Long slotId) throws TuiaMediaException;

    /**
     * update
     * 
     * @param slotId
     * @param directMode
     * @return affect line
     */
    int update(Long slotId, Integer directMode) throws TuiaMediaException;
}
