package cn.com.duiba.tuia.media.dao;

import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.domain.ActivitySortDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqActivitySort;

import java.util.List;

/**
 * Function: ActivitySortDAO
 *
 * @author xuyenan
 * @createTime 2016/10/24
 */
public interface ActivitySortDAO {

    /**
     * insertBatch:(新增). <br/>
     *
     * @author ZFZ
     * @param activitySortDtoList
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    int insertBatch(List<ActivitySortDto> activitySortDtoList) throws TuiaMediaException;

    /**
     * selectByCondition:(根据条件查询 ). <br/>
     *
     * @author ZFZ
     * @param reqActivitySort
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    List<ActivitySortDto> selectByCondition(ReqActivitySort reqActivitySort) throws TuiaMediaException;

    /**
     * selectByConditionAmount:(根据条件查询时的数量). <br/>
     *
     * @author ZFZ
     * @param reqActivitySort
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    int selectByConditionAmount(ReqActivitySort reqActivitySort) throws TuiaMediaException;

    /**
     * deleteAllSlotActivity:(移除某个广告位下的所有活动). <br/>
     *
     * @author ZFZ
     * @param slotId
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    int deleteAllSlotActivity(Long slotId) throws TuiaMediaException;

    /**
     * deleteActivity:(移除所有slot下的某一个活动). <br/>
     *
     * @author ZFZ
     * @param slotId
     * @param activityId
     * @param activityType
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    int deleteActivity(Long slotId, Long activityId, Integer activityType) throws TuiaMediaException;
    
    /**
     * deleteActivityBySource:(移除所有slot下的某一个活动). <br/>
     *
     * @author ZFZ
     * @param slotId
     * @param activityId
     * @param source 活动来源
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    int deleteActivityBySource(Long slotId, Long activityId, Integer source) throws TuiaMediaException;

    /**
     * @param slotId
     * @param activityId
     * @param activityType
     * @param sort
     * @return
     * @throws TuiaMediaException
     */
    int updateSort(Long slotId, Long activityId, Integer activityType, int sort) throws TuiaMediaException;
    
    /**
     * @param slotId
     * @param activityId
     * @param source
     * @param sort
     * @return
     * @throws TuiaMediaException
     */
    int updateSortBySource(Long slotId, Long activityId, Integer source, int sort) throws TuiaMediaException;

    /**
     * 给活动推荐引擎提供的接口：查询所有有效活动
     * 
     * @param appId
     * @return
     * @throws TuiaMediaException
     */
    List<ActivitySortDto> getActivityForRecommendByApp(Long appId) throws TuiaMediaException;

    /**
     * 给活动推荐引擎提供的接口：查询所有有效活动
     * 
     * @param slotId
     * @return
     * @throws TuiaMediaException
     */
    List<ActivitySortDto> getActivityForRecommendBySlot(Long slotId) throws TuiaMediaException;

    /**
     * getAllActivityBySlotId:(通过广告位ID查询所有的活动). <br/>
     *
     * @param slotId
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    List<ActivitySortDto> getAllActivityBySlotId(Long slotId) throws TuiaMediaException;

    /**
     * 批量更新排序值
     * 
     * @param slotId
     * @param startLocation
     * @param endLocation
     * @param step
     * @return affect line
     */
    int updateSortBatch(Long slotId, int startLocation, int endLocation, int step) throws TuiaMediaException;

    /**
     * 查询广告位下按相对排序的活动列表
     * 
     * @param slotId
     * @return 活动列表
     */
    List<ActivitySortDto> selectBySlot(Long slotId) throws TuiaMediaException;
}
