package cn.com.duiba.tuia.media.dao;

import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dataobject.ActivitySpmDO;

import java.util.List;

/**
 * @author xuyenan
 * @createTime 2017/2/8
 */
public interface ActivitySpmDAO {

    /**
     * 获取某个活动在某广告位下的SPM数据
     * 
     * @param slotId 广告位ID
     * @param appId 媒体ID
     * @param statType 统计维度
     * @return 活动SPM数据
     */
    List<ActivitySpmDO> selectBySlot(Long slotId, Long appId, Integer statType) throws TuiaMediaException;

    /**
     * 获取SPM数据
     * 
     * @param activityIds
     * @return
     * @throws TuiaMediaException
     */
    List<ActivitySpmDO> selectByActivityOverall(List<Long> activityIds) throws TuiaMediaException;
}
