package cn.com.duiba.tuia.media.dao;

import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dataobject.MaterialCtrDO;

import java.util.List;

/**
 * @author xuyenan
 * @createTime 2017/2/8
 */
public interface MaterialCtrDAO {

    /**
     * 查询某广告位下的素材CTR列表，按CTR排序
     * 
     * @param slotId 广告位ID
     * @param activityId 活动ID
     * @param activityType 活动TYPE
     * @return 素材列表
     */
    List<MaterialCtrDO> selectBySlotActivity(Long slotId, Long activityId, Integer activityType) throws TuiaMediaException;
    
    /**
     * 查询某广告位下的素材CTR列表，按CTR排序
     * 
     * @param slotId 广告位ID
     * @param activityId 活动ID
     * @param source 活动来源 0：兑吧活动 ；1：推啊活动；2：流量引导页
     * @return 素材列表
     */
    List<MaterialCtrDO> selectBySlotActivityAndSource(Long slotId, Long activityId, Integer source) throws TuiaMediaException;
}
