package cn.com.duiba.tuia.media.dao;

import java.util.List;

import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dataobject.MaterialSpecificationItemContentDO;

/**
 * @author xuyenan
 * @createTime 2016/12/20
 */
public interface MaterialSpecificationItemContentDAO {

    /**
     * insertBatch
     * 
     * @param list
     * @return affect line
     */
    int insertBatch(List<MaterialSpecificationItemContentDO> list) throws TuiaMediaException;

    /**
     * deleteBatch
     * 
     * @param ids 素材ID列表
     * @return affect line
     */
    int deleteBatch(List<Long> ids) throws TuiaMediaException;

    /**
     * 判断活动是否有素材
     * 
     * @param activityId
     * @param activityType
     * @return 活动素材
     */
    int itemContentAmount(Long activityId, Integer activityType) throws TuiaMediaException;
    
    /**
     * 判断活动是否有素材
     * 
     * @param activityId
     * @param source
     * @return 活动素材
     */
    int itemContentAmountBySource(Long activityId, Integer source) throws TuiaMediaException;

    /**
     * selectByActivityAndMsId:获取某个活动某个规格下的所有素材
     * 
     * @param activityId
     * @param activityType
     * @param msId
     * @return 素材列表
     */
    List<MaterialSpecificationItemContentDO> selectByActivityAndMsId(Long activityId, Integer activityType, Long msId)
                                                                                                                      throws TuiaMediaException;

    /**
     * selectByActivityAndMsId:获取某个活动某个规格下的所有素材
     * 
     * @param activityId
     * @param source
     * @param msId
     * @return 素材列表
     */
    List<MaterialSpecificationItemContentDO> selectByActivityAndMsIdAndSource(Long activityId, Integer source, Long msId) throws TuiaMediaException;

    /**
     * 删除某一活动某一规格的所有素材
     * 
     * @param activityId 活动ID
     * @param activityType 活动类型
     * @param msId 规格ID
     * @return affect line
     */
    int deleteByActivityAndMsId(Long activityId, Integer activityType, Long msId) throws TuiaMediaException;
    
    /**
     * 删除某一活动某一规格的所有素材
     * 
     * @param activityId 活动ID
     * @param source 活动类型
     * @param msId 规格ID
     * @return affect line
     */
    int deleteByActivityAndMsIdAndSource(Long activityId, Integer source, Long msId) throws TuiaMediaException;

    /**
     * 查询某个活动的所有规格
     * 
     * @param activityId 活动ID
     * @param activityType 活动类型
     * @return 规格ID列表
     */
    List<Long> selectMsIdsByActivity(Long activityId, Integer activityType) throws TuiaMediaException;
    
    /**
     * 查询某个活动的所有规格
     * 
     * @param activityId 活动ID
     * @param source 活动类型
     * @return 规格ID列表
     */
    List<Long> selectMsIdsByActivityAndSource(Long activityId, Integer source) throws TuiaMediaException;

    /**
     * 新素材曝光量达2000后更改状态
     * 
     * @param id 素材ID
     * @return affect line
     */
    int changeStatus(Long id) throws TuiaMediaException;

    /**
     * selectMsByIds:(通过素材ID查询素材). <br/>
     *
     * @param ids
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    List<MaterialSpecificationItemContentDO> selectMsByIds(List<Long> ids) throws TuiaMediaException;
    
}
