package cn.com.duiba.tuia.media.dao;

import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dataobject.MediaAppActivityDO;

import java.util.List;

/**
 * @author xuyenan
 * @createTime 2016/12/23
 */
public interface MediaAppActivityDAO {

    /**
     * insertBatch
     *
     * @param list
     * @return affect line
     */
    int insertBatch(List<MediaAppActivityDO> list) throws TuiaMediaException;

    /**
     * delete
     *
     * @param activityId 活动ID
     * @param activityType 活动类型
     * @return affect line
     */
    int delete(Long activityId, Integer activityType) throws TuiaMediaException;
    
    /**
     * deleteBySource
     *
     * @param activityId 活动ID
     * @param source 活动来源 0：兑吧活动  ；1：推啊活动；2：流量引导页
     * @return affect line
     */
    int deleteBySource(Long activityId, Integer source) throws TuiaMediaException;

    /**
     * getMediaAppByActivity
     * 
     * @param activityId
     * @param activityType
     * @return 媒体列表
     */
    List<Long> getMediaAppByActivity(Long activityId, Integer activityType) throws TuiaMediaException;
    
    /**
     * getMediaAppByActivityAndSource
     * 
     * @param activityId
     * @param source
     * @return 媒体列表
     */
    List<Long> getMediaAppByActivityAndSource(Long activityId, Integer source) throws TuiaMediaException;
    
    /**
     * getMediaAppByActivity
     * 
     * @param activityId
     * @param source
     * @return 媒体列表
     */
    List<MediaAppActivityDO> getMediaAppByActivity4List(List<Long> activityIds, List<Integer> activityTypes) throws TuiaMediaException;
    
    /**
     * getMediaAppByActivity4ListBySource
     * 
     * @param activityId
     * @param source
     * @return 媒体列表
     */
    List<MediaAppActivityDO> getMediaAppByActivity4ListBySource(List<Long> activityIds, List<Integer> sources) throws TuiaMediaException;
}
