/**
 * Project Name:media-biz File Name:MediaDao.java Package Name:cn.com.duiba.tuia.media.dao Date:2016年9月26日上午11:29:53
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */
package cn.com.duiba.tuia.media.dao;

import java.util.List;

import cn.com.duiba.tuia.media.api.dto.MediaAppDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqUpdateMediaAppStatusDto;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.model.IdAndName;
import cn.com.duiba.tuia.media.model.req.ReqPageQueryMediaApp;
import cn.com.duiba.tuia.media.model.req.ReqUpdateMediaApp;

/**
 * ClassName:MediaAppDao <br/>
 * Function: 媒体管理. <br/>
 * Date: 2016年9月26日 上午11:29:53 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
public interface MediaAppDao {

    /**
     * 创建媒体信息.
     *
     * @param param the param
     * @return the int
     * @throws TuiaMediaException the tuia media exception
     */
    int insert(MediaAppDto param) throws TuiaMediaException;

    /**
     * 获取媒体信息列表.
     *
     * @param mediaAppQuery the media app query
     * @return the list< rsp media app>
     * @throws TuiaMediaException the tuia media exception
     */
    List<MediaAppDto> selectMediaAppList(ReqPageQueryMediaApp mediaAppQuery) throws TuiaMediaException;

    /**
     * 修改媒体信息.
     *
     * @param param the param
     * @return the int
     * @throws TuiaMediaException the tuia media exception
     */
    int update(ReqUpdateMediaApp param) throws TuiaMediaException;

    /**
     * 获取媒体信息.
     *
     * @param appId the app id
     * @return the media app dto
     * @throws TuiaMediaException the tuia media exception
     */
    MediaAppDto selectMediaAppById(Long appId) throws TuiaMediaException;

    /**
     * 通过appKey获取媒体信息.
     *
     * @param appKey the app key
     * @return the media app dto
     * @throws TuiaMediaException the tuia media exception
     */
    MediaAppDto selectByAppKey(String appKey) throws TuiaMediaException;

    /**
     * 查询总数.
     *
     * @param param the param
     * @return the int
     * @throws TuiaMediaException the tuia media exception
     */
    int selectAmountByPageQuery(ReqPageQueryMediaApp param) throws TuiaMediaException;

    /**
     * updateMediaAppStatus:(修改媒体信息状态.). <br/>
     *
     * @author ZFZ
     * @param param
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    int updateMediaAppStatus(ReqUpdateMediaAppStatusDto param) throws TuiaMediaException;

    /**
     * selectAppIdAndName:(根据ID列表查询appId与appName的数据对象列表). <br/>
     *
     * @author ZFZ
     * @param appIds
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    List<IdAndName> selectAppIdAndName(List<Long> appIds) throws TuiaMediaException;

    /**
     * 通过app名称模糊查询appID集合.
     *
     * @param appName the app name
     * @return the list< long>
     * @throws TuiaMediaException the tuia media exception
     */
    List<Long> selectIdsByName(String appName) throws TuiaMediaException;

    /**
     * 通过app名称判断是否存在重名的app.
     *
     * @param appName the app name
     * @return the media app dto
     * @throws TuiaMediaException the tuia media exception
     */
    MediaAppDto getMediaAppByName(String appName) throws TuiaMediaException;

    /**
     * selectAppIdAndNameByMediaId:(通过媒体用户Id获取所有媒体appId和appName). <br/>
     *
     * @author ZFZ
     * @param mediaId
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    List<IdAndName> selectAppIdAndNameByMediaId(Long mediaId) throws TuiaMediaException;

    /**
     * selectByIdAndName:(通过媒体ID和NAME查询). <br/>
     *
     * @author ZFZ
     * @param appId 媒体ID，完全匹配
     * @param appName 媒体名称，模糊匹配
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    List<MediaAppDto> selectByIdAndName(Long appId, String appName) throws TuiaMediaException;

    /**
     * 获取媒体应用的ID和名称.
     *
     * @return the list< id and name>
     * @throws TuiaMediaException the tuia media exception
     */
    List<IdAndName> selectAllAppIdAndName() throws TuiaMediaException;
    
    /**
     * 
     * selectAllAppCache:(获取所有的app信息)供缓存使用. <br/>
     *
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    List<MediaAppDto> selectAllAppCache()throws TuiaMediaException;
}
