/**
 * Project Name:media-biz<br/>
 * File Name:MediaCompanyMsgDAO.java<br/>
 * Package Name:cn.com.duiba.tuia.media.dao<br/>
 * Date:2017年1月22日下午5:51:09<br/>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.media.dao;

import cn.com.duiba.tuia.media.api.dto.MediaCompanyMsgDto;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;

/**
 * ClassName:MediaCompanyMsgDAO <br/>
 * Reason: 媒体公司信息DAO. <br/>
 * Date: 2017年1月22日 下午5:51:09 <br/>
 * 
 * @author ZFZ
 * @version
 * @since JDK 1.6
 * @see
 */
public interface MediaCompanyMsgDAO {

    /**
     * updateCompanyMsg:(媒体用户修改公司信息). <br/>
     *
     * @author ZFZ
     * @param dto
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    int updateCompanyMsg(MediaCompanyMsgDto dto) throws TuiaMediaException;

    /**
     * insertCompanyMsg:(新增用户公司信息). <br/>
     *
     * @author ZFZ
     * @param dto
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    void insertCompanyMsg(MediaCompanyMsgDto dto) throws TuiaMediaException;

    /**
     * selectCompanyMsgById:(通过媒体账户ID查询财务信息下公司信息). <br/>
     *
     * @param mediaId
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    MediaCompanyMsgDto selectCompanyMsgById(Long mediaId) throws TuiaMediaException;
}
