/**
 * Project Name:media-biz<br/>
 * File Name:MediaPersonalMsgDAO.java<br/>
 * Package Name:cn.com.duiba.tuia.media.dao<br/>
 * Date:2017年1月22日下午5:51:40<br/>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.media.dao;

import cn.com.duiba.tuia.media.api.dto.MediaPersonalMsgDto;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;

/**
 * ClassName:MediaPersonalMsgDAO <br/>
 * Reason: 媒体个人信息DAO. <br/>
 * Date: 2017年1月22日 下午5:51:40 <br/>
 * 
 * @author ZFZ
 * @version
 * @since JDK 1.6
 * @see
 */
public interface MediaPersonalMsgDAO {

    /**
     * updatePersonalMsg:(媒体用户修改个人信息). <br/>
     *
     * @author ZFZ
     * @param dto
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    int updatePersonalMsg(MediaPersonalMsgDto dto) throws TuiaMediaException;
    
    /**
     * 
     * selectPersonalMsgById:(通过媒体账户ID查询财务信息下个人信息). <br/>
     *
     * @param mediaId
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    MediaPersonalMsgDto selectPersonalMsgById(Long mediaId) throws TuiaMediaException;

    /**
     * insertPersonalMsg:(新增用户个人信息). <br/>
     *
     * @author ZFZ
     * @param dto
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    void insertPersonalMsg(MediaPersonalMsgDto dto) throws TuiaMediaException;
}
