/**
 * Project Name:media-biz<br>
 * File Name:ShieldStrategyDAO.java<br>
 * Package Name:cn.com.duiba.tuia.media.dao<br>
 * Date:2016年9月26日下午7:43:01<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.media.dao;

import java.util.List;

import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.domain.ShieldStrategyDto;
import cn.com.duiba.tuia.media.model.req.ReqStrategyPageQuery;

/**
 * ClassName: ShieldStrategyDAO <br/>
 * Function: 屏蔽策略. <br/>
 * date: 2016年9月26日 下午7:43:01 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
public interface ShieldStrategyDAO {

    /**
     * 新增屏蔽策略.
     *
     * @param strategyDto the strategy dto
     * @return the int
     * @throws TuiaMediaException the tuia media exception
     */
    int insert(ShieldStrategyDto strategyDto) throws TuiaMediaException;

    /**
     * 更新屏蔽策略.
     *
     * @param strategyDto the strategy dto
     * @return the int
     * @throws TuiaMediaException the tuia media exception
     */
    int update(ShieldStrategyDto strategyDto) throws TuiaMediaException;
    
    
    /**
     * 更新屏蔽策略.
     *
     * @param strategyDto the strategy dto
     * @return the int
     * @throws TuiaMediaException the tuia media exception
     */
    int updateByManager(ShieldStrategyDto strategyDto) throws TuiaMediaException;

    /**
     * 删除屏蔽策略.
     *
     * @param strategyId 屏蔽策略ID
     * @return the int
     * @throws TuiaMediaException the tuia media exception
     */
    int delete(Long strategyId) throws TuiaMediaException;

    /**
     * 查询详情.
     *
     * @param strategyId 屏蔽策略ID
     * @return 屏蔽策略详情
     * @throws TuiaMediaException the tuia media exception
     */
    ShieldStrategyDto selectById(Long strategyId) throws TuiaMediaException;

    /**
     * 查询屏蔽策略列表.
     *
     * @param mediaId 媒体用户ID
     * @return 屏蔽策略列表
     * @throws TuiaMediaException the tuia media exception
     */
    List<ShieldStrategyDto> selectListByMediaId(Long mediaId) throws TuiaMediaException;

    /**
     * 查询符合记录的屏蔽策略列表.
     *
     * @param req the req
     * @return the list< shield strategy dto>
     * @throws TuiaMediaException the tuia media exception
     */
    List<ShieldStrategyDto> selectListByPage(ReqStrategyPageQuery req) throws TuiaMediaException;

    /**
     * 查询符合条件的屏蔽流程记录条数.
     *
     * @param req the req
     * @return the int
     * @throws TuiaMediaException the tuia media exception
     */
    int selectAmountByPage(ReqStrategyPageQuery req) throws TuiaMediaException;

    /**
     * 是否重名.
     *
     * @param id 屏蔽策略ID
     * @param mediaId 媒体用户ID
     * @param name 屏蔽策略名
     * @return true：不重名
     * @throws TuiaMediaException the tuia media exception
     */
    boolean isNotExist(Long id, Long mediaId, String name) throws TuiaMediaException;
    
    
    /**
     * 查询所有未删除的屏蔽策略ID列表.
     *
     * @return the list< long>
     * @throws TuiaMediaException the tuia media exception
     */
    List<Long> selectAllIds() throws TuiaMediaException;
}
