/**
 * Project Name:media-biz<br/>
 * File Name:AdsenseDAO.java<br/>
 * Package Name:cn.com.duiba.tuia.media.dao<br/>
 * Date:2016年9月26日下午7:13:33<br/>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.media.dao;

import java.util.List;

import cn.com.duiba.tuia.media.api.dto.SlotConfigDto;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;

/**
 * 广告位分账比例配置DAO <br/>
 * Date: 2017年3月6日 下午7:13:33 <br/>
 * .
 *
 * @author ZFZ
 * @version
 * @since JDK 1.6
 * @see
 */
public interface SlotConfigDAO {

    /**
     * insertSlotConfig:(创建广告位配置信息). <br/>
     *
     * @author ZFZ
     * @param slotConfigDto
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    int insertSlotConfig(SlotConfigDto slotConfigDto) throws TuiaMediaException;

    /**
     * updateSlotConfig:(修改广告位分账比例配置). <br/>
     *
     * @author ZFZ
     * @param slotConfigDto
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    void updateSlotConfig(SlotConfigDto slotConfigDto) throws TuiaMediaException;

    /**
     * selectSlotConfigDto:(根据广告位ID查询广告位分账比例配置信息). <br/>
     *
     * @author ZFZ
     * @param slotId
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    SlotConfigDto selectSlotConfigDto(Long slotId) throws TuiaMediaException;

    /**
     * selectSlotConfigListByAppId:(根据appId获取app下的所有广告位分账比例配置信息). <br/>
     *
     * @author ZFZ
     * @param appId
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    List<SlotConfigDto> selectSlotConfigListByAppId(Long appId) throws TuiaMediaException;

}
