/**
 * Project Name:media-manager-biz File Name:AccountMonthReportDAOImpl.java Package
 * Name:cn.com.duiba.tuia.media.manager.dao.impl Date:2016年12月1日下午2:30:59 Copyright (c) 2016, duiba.com.cn All Rights
 * Reserved.
 */

package cn.com.duiba.tuia.media.dao.impl;

import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.ListUtils;
import org.springframework.stereotype.Repository;

import cn.com.duiba.tuia.media.api.dto.AccountDayReportDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqSlotLineStatisticsByPageDto;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.AccountDayReportDAO;
import cn.com.duiba.tuia.media.dao.BaseDAO;

/**
 * ClassName:AccountMonthReportDAOImpl <br/>
 * Function: 媒体用户月报表DAO. <br/>
 * Date: 2016年12月1日 下午2:30:59 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
@Repository("accountDayReportDAO")
public class AccountDayReportDAOImpl extends BaseDAO implements AccountDayReportDAO {

    @SuppressWarnings("unchecked")
    @Override
    public List<AccountDayReportDto> selectAppDayBillList(ReqSlotLineStatisticsByPageDto req) throws TuiaMediaException {

        try {
            List<AccountDayReportDto> appDayBillList = getSqlSession().selectList(getStamentNameSpace("selectAppDayBillList"),
                                                                                  req);
            if (CollectionUtils.isEmpty(appDayBillList)) {
                return ListUtils.EMPTY_LIST;
            }
            return appDayBillList;
        } catch (Exception e) {
            logger.error("AccountDayReportDAOImpl.selectAppDayBillList happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @SuppressWarnings("unchecked")
    @Override
    public List<AccountDayReportDto> selectLineData(ReqSlotLineStatisticsByPageDto req) throws TuiaMediaException {
        try {
            List<AccountDayReportDto> selectLineList = getSqlSession().selectList(getStamentNameSpace("selectLineData"),
                                                                                   req);
            if (CollectionUtils.isEmpty(selectLineList)) {
                return ListUtils.EMPTY_LIST;
            }
            return selectLineList;
        } catch (Exception e) {
            logger.error("AccountDayReportDAOImpl.selectLineData happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

}
