package cn.com.duiba.tuia.media.dao.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import cn.com.duiba.tuia.media.api.dto.req.ReqActivityDto;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.ActivityDAO;
import cn.com.duiba.tuia.media.dao.BaseDAO;
import cn.com.duiba.tuia.media.domain.ActivityDto;
import cn.com.duiba.tuia.media.service.cacheservice.ActivityCacheService;

/**
 * Function: ActivityDAOImpl
 *
 * @author xuyenan
 * @createTime 2016/10/24
 */
@Repository
public class ActivityDAOImpl extends BaseDAO implements ActivityDAO {

    @Autowired
    private ActivityCacheService activityCacheService;

    @Override
    public int insert(ActivityDto activityDto) throws TuiaMediaException {
        try {
            return getSqlSession().insert(getStamentNameSpace("insert"), activityDto);
        } catch (Exception e) {
            logger.error("ActivityDAO.insert happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int update(ActivityDto activityDto) throws TuiaMediaException {
        try {
            int line = getSqlSession().update(getStamentNameSpace("update"), activityDto);
            if (line == 1) {
                ActivityDto newActivityDto = getDetail(activityDto.getActivityId(), activityDto.getActivityType());
                activityCacheService.set(newActivityDto);
            }
            return line;
        } catch (Exception e) {
            logger.error("ActivityDAO.update happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<ActivityDto> getList(ReqActivityDto req) throws TuiaMediaException {
        try {
            return getSqlSession().selectList(getStamentNameSpace("getList"), req);
        } catch (Exception e) {
            logger.error("ActivityDAO.getList happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int getListAmount(ReqActivityDto req) throws TuiaMediaException {
        try {
            return getSqlSession().selectOne(getStamentNameSpace("getListAmount"), req);
        } catch (Exception e) {
            logger.error("ActivityDAO.getListAmount happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<ActivityDto> getByIds(List<Long> ids, Integer actSource) throws TuiaMediaException {
        try {
            if (CollectionUtils.isEmpty(ids)) {
                return new ArrayList<>();
            }
            HashMap<String, Object> param = new HashMap<>(2);
            param.put("source", actSource);
            param.put("ids", ids);
            return getSqlSession().selectList(getStamentNameSpace("getByActivityIds"), param);
        } catch (Exception e) {
            logger.error("ActivityDAO.getByIds happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public ActivityDto getDetail(Long activityId, Integer activityType) throws TuiaMediaException {
        try {
            Map<String, Object> map = new HashMap<>();
            map.put("activityId", activityId);
            map.put("activityType", activityType);
            return getSqlSession().selectOne(getStamentNameSpace("getDetail"), map);
        } catch (Exception e) {
            logger.error("ActivityDAO.getDetail happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }
    
    @Override
    public ActivityDto getDetailBySource(Long activityId, Integer source) throws TuiaMediaException {
        try {
            Map<String, Object> map = new HashMap<>();
            map.put("activityId", activityId);
            map.put("source", source);
            return getSqlSession().selectOne(getStamentNameSpace("getDetailBySource"), map);
        } catch (Exception e) {
            logger.error("ActivityDAO.getDetailBySource happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<Long> getIdsByName(String name) throws TuiaMediaException {
        try {
            return getSqlSession().selectList(getStamentNameSpace("getIdsByName"), name);
        } catch (Exception e) {
            logger.error("ActivityDAO.getIdsByName happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<ActivityDto> selectEngineActivityList() throws TuiaMediaException {
        try {
            return getSqlSession().selectList(getStamentNameSpace("selectOldActivity"));
        } catch (Exception e) {
            logger.error("ActivityDAO.selectEngineActivityList happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<ActivityDto> selectNewActivityList() throws TuiaMediaException {
        try {
            return getSqlSession().selectList(getStamentNameSpace("selectNewActivity"));
        } catch (Exception e) {
            logger.error("ActivityDAO.selectNewActivityList happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<Long> selectActivityIdsByName(String activityName) throws TuiaMediaException {
        try {
            return getSqlSession().selectList(getStamentNameSpace("selectActivityIdsByName"), activityName);
        } catch (Exception e) {
            logger.error("ActivityDAO.selectActivityIdsByName happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<Long> selectBySource(int source, int limit) throws TuiaMediaException {
        try {
            Map<String, Object> map = new HashMap<>();
            map.put("source", source);
            map.put("limit", limit);
            return getSqlSession().selectList(getStamentNameSpace("selectBySource"), map);
        } catch (Exception e) {
            logger.error("ActivityDAO.selectBySource happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<ActivityDto> getDetail4List(List<Long> activityIds, List<Integer> activityTypes)
                                                                                                throws TuiaMediaException {
        try {
            Map<String, Object> map = new HashMap<>();
            map.put("activityIds", activityIds);
            map.put("activityTypes", activityTypes);
            return getSqlSession().selectList(getStamentNameSpace("getDetail4List"), map);
        } catch (Exception e) {
            logger.error("ActivityDAO.getDetail4List happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<ActivityDto> getDetail4ListBySource(List<Long> activityIds, List<Integer> sources)
                                                                                                 throws TuiaMediaException {
        try {
            Map<String, Object> map = new HashMap<>();
            map.put("activityIds", activityIds);
            map.put("sources", sources);
            return getSqlSession().selectList(getStamentNameSpace("getDetail4ListBySource"), map);
        } catch (Exception e) {
            logger.error("ActivityDAO.getDetail4ListBySource happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }
}
