package cn.com.duiba.tuia.media.dao.impl;

import cn.com.duiba.tuia.media.api.dto.req.ReqActivitySort;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.ActivitySortDAO;
import cn.com.duiba.tuia.media.dao.BaseDAO;
import cn.com.duiba.tuia.media.domain.ActivitySortDto;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Function: ActivitySortDAOImpl
 *
 * @author xuyenan
 * @createTime 2016/10/24
 */
@Repository
public class ActivitySortDAOImpl extends BaseDAO implements ActivitySortDAO {

    @Override
    public int insertBatch(List<ActivitySortDto> activitySortDtoList) throws TuiaMediaException {
        try {
            if (CollectionUtils.isEmpty(activitySortDtoList)) {
                return 0;
            }
            return getSqlSession().insert(getStamentNameSpace("insertBatch"), activitySortDtoList);
        } catch (Exception e) {
            logger.error("ActivitySortDAO.insertBatch data happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<ActivitySortDto> selectByCondition(ReqActivitySort reqActivitySort) throws TuiaMediaException {
        try {
            return getSqlSession().selectList(getStamentNameSpace("selectByCondition"), reqActivitySort);
        } catch (Exception e) {
            logger.error("ActivitySortDAO.selectByCondition happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int selectByConditionAmount(ReqActivitySort reqActivitySort) throws TuiaMediaException {
        try {
            return getSqlSession().selectOne(getStamentNameSpace("selectByConditionAmount"), reqActivitySort);
        } catch (Exception e) {
            logger.error("ActivitySortDAO.selectByConditionAmount happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int deleteAllSlotActivity(Long slotId) throws TuiaMediaException {
        try {
            return getSqlSession().delete(getStamentNameSpace("deleteAllSlotActivity"), slotId);
        } catch (Exception e) {
            logger.error("ActivitySortDAO.deleteAppAllActivity happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int deleteActivity(Long slotId, Long activityId, Integer activityType) throws TuiaMediaException {
        try {
            Map<String, Object> map = new HashMap<>();
            map.put("slotId", slotId);
            map.put("activityId", activityId);
            map.put("activityType", activityType);
            return getSqlSession().delete(getStamentNameSpace("deleteActivity"), map);
        } catch (Exception e) {
            logger.error("ActivitySortDAO.deleteActivity happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }
    
    @Override
    public int deleteActivityBySource(Long slotId, Long activityId, Integer source) throws TuiaMediaException {
        try {
            Map<String, Object> map = new HashMap<>();
            map.put("slotId", slotId);
            map.put("activityId", activityId);
            map.put("source", source);
            return getSqlSession().delete(getStamentNameSpace("deleteActivityBySource"), map);
        } catch (Exception e) {
            logger.error("ActivitySortDAO.deleteActivityBySource happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<ActivitySortDto> getActivityForRecommendByApp(Long appId) throws TuiaMediaException {
        try {
            return getSqlSession().selectList(getStamentNameSpace("getActivityForRecommendByApp"), appId);
        } catch (Exception e) {
            logger.error("ActivitySortDAO.getActivityForRecommendByApp happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<ActivitySortDto> getActivityForRecommendBySlot(Long slotId) throws TuiaMediaException {
        try {
            return getSqlSession().selectList(getStamentNameSpace("getActivityForRecommendBySlotId"), slotId);
        } catch (Exception e) {
            logger.error("ActivitySortDAO.getActivityForRecommendBySlot happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int updateSort(Long slotId, Long activityId, Integer activityType, int sort) throws TuiaMediaException {
        try {
            Map<String, Object> params = new HashMap<>();
            params.put("activitySlotId", slotId);
            params.put("activityId", activityId);
            params.put("activityType", activityType);
            params.put("absoluteSort", sort);
            return getSqlSession().update(getStamentNameSpace("updateSort"), params);
        } catch (Exception e) {
            logger.error("ActivitySortDAO.updateSort happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }
    
    @Override
    public int updateSortBySource(Long slotId, Long activityId, Integer source, int sort) throws TuiaMediaException {
        try {
            Map<String, Object> params = new HashMap<>();
            params.put("activitySlotId", slotId);
            params.put("activityId", activityId);
            params.put("source", source);
            params.put("absoluteSort", sort);
            return getSqlSession().update(getStamentNameSpace("updateSortBySource"), params);
        } catch (Exception e) {
            logger.error("ActivitySortDAO.updateSortBySource happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<ActivitySortDto> getAllActivityBySlotId(Long slotId) throws TuiaMediaException {
        try {
            return getSqlSession().selectList(getStamentNameSpace("getAllActivityBySlotId"), slotId);
        } catch (Exception e) {
            logger.error("ActivitySortDAO.getAllActivityBySlotId happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int updateSortBatch(Long slotId, int startLocation, int endLocation, int step) throws TuiaMediaException {
        try {
            Map<String, Object> map = new HashMap<>();
            map.put("slotId", slotId);
            map.put("startLocation", startLocation);
            map.put("endLocation", endLocation);
            map.put("step", step);
            return getSqlSession().update(getStamentNameSpace("updateSortBatch"), map);
        } catch (Exception e) {
            logger.error("ActivitySortDAO.updateSortBatch happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<ActivitySortDto> selectBySlot(Long slotId) throws TuiaMediaException {
        try {
            return getSqlSession().selectList(getStamentNameSpace("selectBySlot"), slotId);
        } catch (Exception e) {
            logger.error("ActivitySortDAO.selectBySlot happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }
}
