package cn.com.duiba.tuia.media.dao.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.ActivitySpmDAO;
import cn.com.duiba.tuia.media.dao.BaseDAO;
import cn.com.duiba.tuia.media.dataobject.ActivitySpmDO;

/**
 * @author xuyenan
 * @createTime 2017/2/8
 */
@Repository("activitySpmDAO")
public class ActivitySpmDAOImpl extends BaseDAO implements ActivitySpmDAO {

    @Override
    public List<ActivitySpmDO> selectBySlot(Long slotId, Long appId, Integer statType) throws TuiaMediaException {
        try {
            Map<String, Object> map = new HashMap<>();
            map.put("slotId", slotId);
            map.put("appId", appId);
            map.put("statType", statType);
            return getSqlSession().selectList(getStamentNameSpace("selectBySlot"), map);
        } catch (Exception e) {
            logger.error("ActivitySpmDAO.selectBySlot data happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<ActivitySpmDO> selectByActivityOverall(List<Long> activityIds) throws TuiaMediaException {
        try {
            return getSqlSession().selectList(getStamentNameSpace("selectByActivityOverall"), activityIds);
        } catch (Exception e) {
            logger.error("ActivitySpmDAO.selectByActivityOverall data happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }
}
