/**
 * Project Name:media-biz<br>
 * File Name:ActivityStatisticsDayDAOImpl.java<br>
 * Package Name:cn.com.duiba.tuia.media.dao.impl<br>
 * Date:2016年10月18日下午1:51:35<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.media.dao.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.ActivityStatisticsDayDAO;
import cn.com.duiba.tuia.media.dao.BaseDAO;
import cn.com.duiba.tuia.media.domain.ActivityStatisticsDayDto;
import cn.com.duiba.tuia.media.model.req.ReqActivityData;

/**
 * ClassName: ActivityStatisticsDayDAOImpl <br/>
 * Function: 活动统计数据. <br/>
 * date: 2016年10月18日 下午1:51:35 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
@Repository
public class ActivityStatisticsDayDAOImpl extends BaseDAO implements ActivityStatisticsDayDAO {

    @Override
    public int selectAmountByPage(ReqActivityData req) throws TuiaMediaException {
        try {
            return getSqlSession().selectOne(getStamentNameSpace("selectAmountByPage"), req);
        } catch (Exception e) {
            logger.error("ActivityStatisticsDayDAO.selectAmountByPage happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0001005);
        }
    }

    @Override
    public List<ActivityStatisticsDayDto> selectListByPage(ReqActivityData req) throws TuiaMediaException {
        try {
            return getSqlSession().selectList(getStamentNameSpace("selectListByPage"), req);
        } catch (Exception e) {
            logger.error("ActivityStatisticsDayDAO.selectListByPage happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0001005);
        }
    }
    

    @Override
    public List<ActivityStatisticsDayDto> selectListByPageBySource(ReqActivityData req) throws TuiaMediaException {
        try {
            return getSqlSession().selectList(getStamentNameSpace("selectListByPageBySource"), req);
        } catch (Exception e) {
            logger.error("ActivityStatisticsDayDAO.selectListByPage happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0001005);
        }
    }

    @Override
    public int selectAmountByDetail(ReqActivityData req) throws TuiaMediaException {
        try {
            return getSqlSession().selectOne(getStamentNameSpace("selectAmountByDetail"), req);
        } catch (Exception e) {
            logger.error("ActivityStatisticsDayDAO.selectAmountByDetail happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0001005);
        }
    }

    @Override
    public List<ActivityStatisticsDayDto> selectListByDetail(ReqActivityData req) throws TuiaMediaException {
        try {
            return getSqlSession().selectList(getStamentNameSpace("selectListByDetail"), req);
        } catch (Exception e) {
            logger.error("ActivityStatisticsDayDAO.selectListByDetail happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0001005);
        }
    }

    @Override
    public List<ActivityStatisticsDayDto> selectExposureAndLaunchAdvert(List<Long> activityIds,
                                                                        Long activityAppId) throws TuiaMediaException {
        try {
            Map<String, Object> map = new HashMap<>(2);
            map.put("activityIds", activityIds);
            map.put("activityAppId", activityAppId);
            return getSqlSession().selectList(getStamentNameSpace("selectExposureAndLaunchAdvert"), map);
        } catch (Exception e) {
            logger.error("ActivityStatisticsDayDAO.selectExposureAndLaunchAdvert happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001);
        }
    }

}
