package cn.com.duiba.tuia.media.dao.impl;

import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.BaseDAO;
import cn.com.duiba.tuia.media.dao.MaterialCtrDAO;
import cn.com.duiba.tuia.media.dataobject.MaterialCtrDO;

import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author xuyenan
 * @createTime 2017/2/8
 */
@Repository("materialCtrDAO")
public class MaterialCtrDAOImpl extends BaseDAO implements MaterialCtrDAO {

    @Override
    public List<MaterialCtrDO> selectBySlotActivity(Long slotId, Long activityId, Integer activityType) throws TuiaMediaException {
        try {
            Map<String, Object> map = new HashMap<>();
            map.put("slotId", slotId);
            map.put("activityId", activityId);
            map.put("activityType", activityType);
            return getSqlSession().selectList(getStamentNameSpace("selectBySlotActivity"), map);
        } catch (Exception e) {
            logger.error("MaterialCtrDAO.selectBySlotActivity data happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<MaterialCtrDO> selectBySlotActivityAndSource(Long slotId, Long activityId, Integer source)
                                                                                                          throws TuiaMediaException {
        try {
            Map<String, Object> map = new HashMap<>();
            map.put("slotId", slotId);
            map.put("activityId", activityId);
            map.put("source", source);
            return getSqlSession().selectList(getStamentNameSpace("selectBySlotActivityAndSource"), map);
        } catch (Exception e) {
            logger.error("MaterialCtrDAO.selectBySlotActivityAndSource data happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }
}
