package cn.com.duiba.tuia.media.dao.impl;

import cn.com.duiba.tuia.media.api.dto.req.ReqMaterialSpecificationDto;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.BaseDAO;
import cn.com.duiba.tuia.media.dao.MaterialSpecificationDAO;
import cn.com.duiba.tuia.media.dataobject.MaterialSpecificationDO;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Repository;

import java.util.Collections;
import java.util.List;

/**
 * @author xuyenan
 * @createTime 2016/12/20
 */
@Repository("materialSpecificationDAO")
public class MaterialSpecificationDAOImpl extends BaseDAO implements MaterialSpecificationDAO {

    @Override
    public int insert(MaterialSpecificationDO materialSpecificationDO) throws TuiaMediaException {
        try {
            return getSqlSession().insert(getStamentNameSpace("insert"), materialSpecificationDO);
        } catch (Exception e) {
            logger.error("MaterialSpecificationDAO.insert happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int update(MaterialSpecificationDO materialSpecificationDO) throws TuiaMediaException {
        try {
            return getSqlSession().update(getStamentNameSpace("update"), materialSpecificationDO);
        } catch (Exception e) {
            logger.error("MaterialSpecificationDAO.update happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int delete(Long msId) throws TuiaMediaException {
        try {
            return getSqlSession().update(getStamentNameSpace("softDelete"), msId);
        } catch (Exception e) {
            logger.error("MaterialSpecificationDAO.delete happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<MaterialSpecificationDO> getList(ReqMaterialSpecificationDto req) throws TuiaMediaException {
        try {
            return getSqlSession().selectList(getStamentNameSpace("getList"), req);
        } catch (Exception e) {
            logger.error("MaterialSpecificationDAO.getList happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int getAmount(ReqMaterialSpecificationDto req) throws TuiaMediaException {
        try {
            return getSqlSession().selectOne(getStamentNameSpace("getAmount"), req);
        } catch (Exception e) {
            logger.error("MaterialSpecificationDAO.getAmount happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public MaterialSpecificationDO getById(Long id) throws TuiaMediaException {
        try {
            return getSqlSession().selectOne(getStamentNameSpace("getById"), id);
        } catch (Exception e) {
            logger.error("MaterialSpecificationDAO.getById happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<MaterialSpecificationDO> getByIds(List<Long> ids) throws TuiaMediaException {
        try {
            if (CollectionUtils.isEmpty(ids)) {
                return Collections.emptyList();
            }
            return getSqlSession().selectList(getStamentNameSpace("getByIds"), ids);
        } catch (Exception e) {
            logger.error("MaterialSpecificationDAO.getByIds happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }
    
    @Override
    public List<Long> selectMsIdByName(String msName) throws TuiaMediaException {
        try {
            return getSqlSession().selectList(getStamentNameSpace("selectMsIdByName"), msName);
        } catch (Exception e) {
            logger.error("MaterialSpecificationDAO.selectMsIdByName happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }
}
