package cn.com.duiba.tuia.media.dao.impl;

import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.BaseDAO;
import cn.com.duiba.tuia.media.dao.MaterialSpecificationItemContentDAO;
import cn.com.duiba.tuia.media.dataobject.MaterialSpecificationItemContentDO;

import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author xuyenan
 * @createTime 2016/12/20
 */
@Repository("materialSpecificationItemContentDAO")
public class MaterialSpecificationItemContentDAOImpl extends BaseDAO implements MaterialSpecificationItemContentDAO {

    @Override
    public int insertBatch(List<MaterialSpecificationItemContentDO> list) throws TuiaMediaException {
        try {
            if (CollectionUtils.isEmpty(list)) {
                return 0;
            }
            return getSqlSession().insert(getStamentNameSpace("insertBatch"), list);
        } catch (Exception e) {
            logger.error("MaterialSpecificationItemContentDAO.insertBatch happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int deleteBatch(List<Long> ids) throws TuiaMediaException {
        try {
            if (CollectionUtils.isEmpty(ids)) {
                return 0;
            }
            return getSqlSession().delete(getStamentNameSpace("deleteBatch"), ids);
        } catch (Exception e) {
            logger.error("MaterialSpecificationItemContentDAO.deleteBatch happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int itemContentAmount(Long activityId, Integer activityType) throws TuiaMediaException {
        try {
            Map<String, Object> map = new HashMap<>();
            map.put("activityId", activityId);
            map.put("activityType", activityType);
            return getSqlSession().selectOne(getStamentNameSpace("itemContentAmount"), map);
        } catch (Exception e) {
            logger.error("MaterialSpecificationItemContentDAO.hasItemContent happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<MaterialSpecificationItemContentDO> selectByActivityAndMsId(Long activityId, Integer activityType,
                                                                            Long msId) throws TuiaMediaException {
        try {
            Map<String, Object> map = new HashMap<>();
            map.put("activityId", activityId);
            map.put("activityType", activityType);
            map.put("msId", msId);
            return getSqlSession().selectList(getStamentNameSpace("selectByActivityAndMsId"), map);
        } catch (Exception e) {
            logger.error("MaterialSpecificationItemContentDAO.selectByActivityAndMsId happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int deleteByActivityAndMsId(Long activityId, Integer activityType, Long msId) throws TuiaMediaException {
        try {
            Map<String, Object> map = new HashMap<>();
            map.put("activityId", activityId);
            map.put("activityType", activityType);
            map.put("msId", msId);
            return getSqlSession().delete(getStamentNameSpace("deleteByActivityAndMsId"), map);
        } catch (Exception e) {
            logger.error("MaterialSpecificationItemContentDAO.deleteByActivityAndMsId happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<Long> selectMsIdsByActivity(Long activityId, Integer activityType) throws TuiaMediaException {
        try {
            Map<String, Object> map = new HashMap<>();
            map.put("activityId", activityId);
            map.put("activityType", activityType);
            return getSqlSession().selectList(getStamentNameSpace("selectMsIdsByActivity"), map);
        } catch (Exception e) {
            logger.error("MaterialSpecificationItemContentDAO.selectMsIdsByActivity happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int changeStatus(Long id) throws TuiaMediaException {
        try {
            return getSqlSession().update(getStamentNameSpace("changeStatus"), id);
        } catch (Exception e) {
            logger.error("MaterialSpecificationItemContentDAO.changeStatus happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int itemContentAmountBySource(Long activityId, Integer source) throws TuiaMediaException {
        try {
            Map<String, Object> map = new HashMap<>();
            map.put("activityId", activityId);
            map.put("source", source);
            return getSqlSession().selectOne(getStamentNameSpace("itemContentAmountBySource"), map);
        } catch (Exception e) {
            logger.error("MaterialSpecificationItemContentDAO.hasItemContent happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<MaterialSpecificationItemContentDO> selectByActivityAndMsIdAndSource(Long activityId, Integer source,
                                                                                     Long msId)
                                                                                               throws TuiaMediaException {
        try {
            Map<String, Object> map = new HashMap<>();
            map.put("activityId", activityId);
            map.put("source", source);
            map.put("msId", msId);
            return getSqlSession().selectList(getStamentNameSpace("selectByActivityAndMsIdAndSource"), map);
        } catch (Exception e) {
            logger.error("MaterialSpecificationItemContentDAO.selectByActivityAndMsIdAndSource happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int deleteByActivityAndMsIdAndSource(Long activityId, Integer source, Long msId) throws TuiaMediaException {
        try {
            Map<String, Object> map = new HashMap<>();
            map.put("activityId", activityId);
            map.put("source", source);
            map.put("msId", msId);
            return getSqlSession().delete(getStamentNameSpace("deleteByActivityAndMsIdAndSource"), map);
        } catch (Exception e) {
            logger.error("MaterialSpecificationItemContentDAO.deleteByActivityAndMsIdAndSource happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<Long> selectMsIdsByActivityAndSource(Long activityId, Integer source) throws TuiaMediaException {
        try {
            Map<String, Object> map = new HashMap<>();
            map.put("activityId", activityId);
            map.put("source", source);
            return getSqlSession().selectList(getStamentNameSpace("selectMsIdsByActivityAndSource"), map);
        } catch (Exception e) {
            logger.error("MaterialSpecificationItemContentDAO.selectMsIdsByActivityAndSource happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }
    
    @Override
    public List<MaterialSpecificationItemContentDO> selectMsByIds(List<Long> ids) throws TuiaMediaException {
        try {
            return getSqlSession().selectList(getStamentNameSpace("selectMsByIds"), ids);
        } catch (Exception e) {
            logger.error("MaterialSpecificationItemContentDAO.selectMsByIds happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }
}
