package cn.com.duiba.tuia.media.dao.impl;

import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.BaseDAO;
import cn.com.duiba.tuia.media.dao.MediaAppActivityDAO;
import cn.com.duiba.tuia.media.dataobject.MediaAppActivityDO;

import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author xuyenan
 * @createTime 2016/12/23
 */
@Repository("mediaAppActivityDAO")
public class MediaAppActivityDAOImpl extends BaseDAO implements MediaAppActivityDAO {

    @Override
    public int insertBatch(List<MediaAppActivityDO> list) throws TuiaMediaException {
        try {
            if (CollectionUtils.isEmpty(list)) {
                return 0;
            }
            return getSqlSession().insert(getStamentNameSpace("insertBatch"), list);
        } catch (Exception e) {
            logger.error("MediaAppActivityDAO.insertBatch happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int delete(Long activityId, Integer activityType) throws TuiaMediaException {
        try {
            Map<String, Object> map = new HashMap<>();
            map.put("activityId", activityId);
            map.put("activityType", activityType);
            return getSqlSession().delete(getStamentNameSpace("delete"), map);
        } catch (Exception e) {
            logger.error("MediaAppActivityDAO.delete happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }
    
    @Override
    public int deleteBySource(Long activityId, Integer source) throws TuiaMediaException{
        try {
            Map<String, Object> map = new HashMap<>();
            map.put("activityId", activityId);
            map.put("source", source);
            return getSqlSession().delete(getStamentNameSpace("deleteBySource"), map);
        } catch (Exception e) {
            logger.error("MediaAppActivityDAO.deleteBySource happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<Long> getMediaAppByActivity(Long activityId, Integer activityType) throws TuiaMediaException {
        try {
            Map<String, Object> map = new HashMap<>();
            map.put("activityId", activityId);
            map.put("activityType", activityType);
            return getSqlSession().selectList(getStamentNameSpace("getMediaAppByActivity"), map);
        } catch (Exception e) {
            logger.error("MediaAppActivityDAO.getMediaAppByActivity happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }
    
    @Override
    public List<Long> getMediaAppByActivityAndSource(Long activityId, Integer source) throws TuiaMediaException {
        try {
            Map<String, Object> map = new HashMap<>();
            map.put("activityId", activityId);
            map.put("source", source);
            return getSqlSession().selectList(getStamentNameSpace("getMediaAppByActivityAndSource"), map);
        } catch (Exception e) {
            logger.error("MediaAppActivityDAO.getMediaAppByActivityAndSource happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }
    
    @Override
    public List<MediaAppActivityDO> getMediaAppByActivity4List(List<Long> activityIds, List<Integer> activityTypes)
                                                                                                                   throws TuiaMediaException {
        try {
            Map<String, Object> map = new HashMap<>();
            map.put("activityIds", activityIds);
            map.put("activityTypes", activityTypes);
            return getSqlSession().selectList(getStamentNameSpace("getMediaAppByActivity4List"), map);
        } catch (Exception e) {
            logger.error("MediaAppActivityDAO.getMediaAppByActivity happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<MediaAppActivityDO> getMediaAppByActivity4ListBySource(List<Long> activityIds, List<Integer> sources)
                                                                                                                     throws TuiaMediaException {
        try {
            Map<String, Object> map = new HashMap<>();
            map.put("activityIds", activityIds);
            map.put("activityTypes", sources);
            return getSqlSession().selectList(getStamentNameSpace("getMediaAppByActivity4ListBySource"), map);
        } catch (Exception e) {
            logger.error("MediaAppActivityDAO.getMediaAppByActivity4ListBySource happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }
}
