package cn.com.duiba.tuia.media.dao.impl;

import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.BaseDAO;
import cn.com.duiba.tuia.media.dao.MediaAppMsDAO;
import cn.com.duiba.tuia.media.dataobject.MediaAppMsDO;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * @author xuyenan
 * @createTime 2016/12/20
 */
@Repository("mediaAppMsDAO")
public class MediaAppMsDAOImpl extends BaseDAO implements MediaAppMsDAO {

    @Override
    public int insertBatch(List<MediaAppMsDO> list) throws TuiaMediaException {
        try {
            if (CollectionUtils.isEmpty(list)) {
                return 0;
            }
            return getSqlSession().insert(getStamentNameSpace("insertBatch"), list);
        } catch (Exception e) {
            logger.error("MediaAppMsDAO.insertBatch happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int delete(Long msId) throws TuiaMediaException {
        try {
            return getSqlSession().delete(getStamentNameSpace("delete"), msId);
        } catch (Exception e) {
            logger.error("MediaAppMsDAO.insertBatch happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<Long> getAppIdsByMsId(Long msId) throws TuiaMediaException {
        try {
            return getSqlSession().selectList(getStamentNameSpace("getAppIdsByMsId"), msId);
        } catch (Exception e) {
            logger.error("MediaAppMsDAO.getAppIdsByMsId happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<Long> getMsIdsExceptTheMediaApp(Long mediaId) throws TuiaMediaException {
        try {
            return getSqlSession().selectList(getStamentNameSpace("getMsIdsExceptTheMediaApp"), mediaId);
        } catch (Exception e) {
            logger.error("MediaAppMsDAO.getMsIdsExceptTheMediaApp happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<Long> getMsIdsByMediaApp(Long mediaId) throws TuiaMediaException {
        try {
            return getSqlSession().selectList(getStamentNameSpace("getMsIdsByMediaApp"), mediaId);
        } catch (Exception e) {
            logger.error("MediaAppMsDAO.getMsIdsByMediaApp happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }
}
