/**
 * Project Name:media-biz<br/>
 * File Name:MediaCompanyMsgDAOImpl.java<br/>
 * Package Name:cn.com.duiba.tuia.media.dao.impl<br/>
 * Date:2017年1月22日下午5:57:40<br/>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.media.dao.impl;

import org.springframework.stereotype.Repository;

import cn.com.duiba.tuia.media.api.dto.MediaCompanyMsgDto;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.BaseDAO;
import cn.com.duiba.tuia.media.dao.MediaCompanyMsgDAO;

/**
 * ClassName:MediaCompanyMsgDAOImpl <br/>
 * Function: 修改公司信息DAO实现. <br/>
 * Date: 2017年1月22日 下午5:57:40 <br/>
 * 
 * @author ZFZ
 * @version
 * @since JDK 1.6
 * @see
 */

@Repository
public class MediaCompanyMsgDAOImpl extends BaseDAO implements MediaCompanyMsgDAO {

    @Override
    public int updateCompanyMsg(MediaCompanyMsgDto dto) throws TuiaMediaException {
        try {
            return getSqlSession().update(getStamentNameSpace("updateCompanyMsg"), dto);
        } catch (Exception e) {
            logger.error("MediaCompanyMsgDAOImpl.updateCompanyMsg happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public void insertCompanyMsg(MediaCompanyMsgDto dto) throws TuiaMediaException {
        try {
            getSqlSession().insert(getStamentNameSpace("insertCompanyMsg"), dto);
        } catch (Exception e) {
            logger.error("MediaCompanyMsgDAOImpl.insertCompanyMsg happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public MediaCompanyMsgDto selectCompanyMsgById(Long mediaId) throws TuiaMediaException {
        try {
            return getSqlSession().selectOne(getStamentNameSpace("selectCompanyMsgById"), mediaId);
        } catch (Exception e) {
            logger.error("MediaCompanyMsgDAOImpl.selectCompanyMsgById happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

}
