/**
 * Project Name:media-biz<br/>
 * File Name:MediaPersonalMsgDAOImpl.java<br/>
 * Package Name:cn.com.duiba.tuia.media.dao.impl<br/>
 * Date:2017年1月22日下午5:57:59<br/>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.media.dao.impl;

import org.springframework.stereotype.Repository;

import cn.com.duiba.tuia.media.api.dto.MediaPersonalMsgDto;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.BaseDAO;
import cn.com.duiba.tuia.media.dao.MediaPersonalMsgDAO;

/**
 * ClassName:MediaPersonalMsgDAOImpl <br/>
 * Function: 修改个人信息DAO实现类. <br/>
 * Date: 2017年1月22日 下午5:57:59 <br/>
 * 
 * @author ZFZ
 * @version
 * @since JDK 1.6
 * @see
 */
@Repository
public class MediaPersonalMsgDAOImpl extends BaseDAO implements MediaPersonalMsgDAO {

    @Override
    public int updatePersonalMsg(MediaPersonalMsgDto dto) throws TuiaMediaException {
        try {
            return getSqlSession().update(getStamentNameSpace("updatePersonalMsg"), dto);
        } catch (Exception e) {
            logger.error("MediaCompanyMsgDAOImpl.updatePersonalMsg happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public MediaPersonalMsgDto selectPersonalMsgById(Long mediaId) throws TuiaMediaException {
        try {
            return getSqlSession().selectOne(getStamentNameSpace("selectPersonalMsgById"), mediaId);
        } catch (Exception e) {
            logger.error("MediaPersonalMsgDAOImpl.selectPersonalMsgById happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public void insertPersonalMsg(MediaPersonalMsgDto dto) throws TuiaMediaException {
        try {
            getSqlSession().insert(getStamentNameSpace("insertPersonalMsg"), dto);
        } catch (Exception e) {
            logger.error("MediaPersonalMsgDAOImpl.insertPersonalMsg happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }
}
