/**
 * Project Name:media-biz<br/>
 * File Name:SlotConfigDAOImpl.java<br/>
 * Package Name:cn.com.duiba.tuia.media.dao.impl<br/>
 * Date:2017年3月6日上午11:07:12<br/>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.media.dao.impl;

import java.util.List;

import org.springframework.stereotype.Repository;

import cn.com.duiba.tuia.media.api.dto.SlotConfigDto;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.BaseDAO;
import cn.com.duiba.tuia.media.dao.SlotConfigDAO;

/**
 * ClassName:SlotConfigDAOImpl <br/>
 * Date: 2017年3月6日 上午11:07:12 <br/>
 * 
 * @author ZFZ
 * @version
 * @since JDK 1.6
 * @see
 */

@Repository("slotConfigDAO")
public class SlotConfigDAOImpl extends BaseDAO implements SlotConfigDAO {

    @Override
    public int insertSlotConfig(SlotConfigDto slotConfigDto) throws TuiaMediaException {
        try {
            return getSqlSession().insert(getStamentNameSpace("insertSlotConfig"), slotConfigDto);
        } catch (Exception e) {
            logger.error("SlotConfigDAO.insertSlotConfig happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public void updateSlotConfig(SlotConfigDto slotConfigDto) throws TuiaMediaException {
        try {
            getSqlSession().update(getStamentNameSpace("updateSlotConfig"), slotConfigDto);
        } catch (Exception e) {
            logger.error("SlotConfigDAO.updateSlotConfig happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public SlotConfigDto selectSlotConfigDto(Long slotId) throws TuiaMediaException {
        try {
            return getSqlSession().selectOne(getStamentNameSpace("selectSlotConfigDto"), slotId);
        } catch (Exception e) {
            logger.error("SlotConfigDAO.selectSlotConfigDto happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<SlotConfigDto> selectSlotConfigListByAppId(Long appId) throws TuiaMediaException {
        try {
            return getSqlSession().selectList(getStamentNameSpace("selectSlotConfigListByAppId"), appId);
        } catch (Exception e) {
            logger.error("SlotConfigDAO.selectSlotConfigListByAppId happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

}
