/**
 * Project Name:media-biz<br>
 * File Name:StatisticsDAOImpl.java<br>
 * Package Name:cn.com.duiba.tuia.media.dao.impl<br>
 * Date:2016年10月10日下午4:33:14<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.media.dao.impl;

import java.util.List;

import org.springframework.stereotype.Repository;

import cn.com.duiba.tuia.media.api.dto.MeidaActivitySlotStatisticsDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqMediaAppStatisticsDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqSlotLineStatisticsByPageDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqSlotStatisticsDto;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.BaseDAO;
import cn.com.duiba.tuia.media.dao.SlotStatisticsDAO;

/**
 * ClassName: SlotStatisticsDAOImpl <br/>
 * date: 2016年10月10日 下午4:33:14 <br/>
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
@Repository
public class SlotStatisticsDAOImpl extends BaseDAO implements SlotStatisticsDAO {

    @Override
    public int selectSlotDataAmout(ReqSlotStatisticsDto req) throws TuiaMediaException {
        try {
            return getSqlSession().selectOne(getStamentNameSpace("selectSlotDataAmout"), req);
        } catch (Exception e) {
            logger.error("SlotStatisticsDAOImpl.selectSlotDataAmout data happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<MeidaActivitySlotStatisticsDto> selectListSlotDataByPage(ReqSlotStatisticsDto req)
                                                                                                  throws TuiaMediaException {
        try {
            return getSqlSession().selectList(getStamentNameSpace("selectListSlotDataByPage"), req);
        } catch (Exception e) {
            logger.error("SlotStatisticsDAOImpl.selectListSlotDataByPage data happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int selectMediaDataAmount(ReqMediaAppStatisticsDto req) throws TuiaMediaException {
        try {
            return getSqlSession().selectOne(getStamentNameSpace("selectMediaDataAmount"), req);
        } catch (Exception e) {
            logger.error("SlotStatisticsDAOImpl.selectMediaDataAmount data happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<MeidaActivitySlotStatisticsDto> selectListMediaDataByPage(ReqMediaAppStatisticsDto req)
                                                                                                       throws TuiaMediaException {
        try {
            return getSqlSession().selectList(getStamentNameSpace("selectListMediaDataByPage"), req);
        } catch (Exception e) {
            logger.error("SlotStatisticsDAOImpl.selectListMediaDataByPage data happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<MeidaActivitySlotStatisticsDto> selectByDate(ReqSlotLineStatisticsByPageDto param) throws TuiaMediaException {
        try {
            return getSqlSession().selectList(getStamentNameSpace("selectByDate"), param);
        } catch (Exception e) {
            logger.error("the SlotStatisticsDAOImpl.selectByDate data happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0001005);
        }

    }

}
