package cn.com.duiba.tuia.media.dataobject;

import java.util.Date;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ActivityManualPlanDO
 */
public class ActivityManualPlanDO extends BaseDO {

    /** 未开始 */
    public static final int STATUS_PREVIEW  = 0;

    /** 正在投放 */
    public static final int STATUS_RELEASE  = 1;

    /** 已过期 */
    public static final int STATUS_EXPIRED  = 2;

    /** 计划类型 0-活动 */
    public static final int PLAN_TYPE_ACT   = 0;

    /** 计划类型 1-主会场 */
    public static final int PLAN_TYPE_VENUE = 1;

    private Long            activityId;

    private Integer         activityType;

    private String          activityUrl;

    private Long            operatorActivityId;

    private Date            releaseTime;

    private Integer         status;

    private Long            slotId;

    private Integer         planType;

    private String          activityName;
    
    private Integer          source;             // 活动来源 0：兑吧活动 ；1：推啊活动；2：流量引导页

    /**
     * activityName.
     *
     * @return the activityName
     * @since JDK 1.6
     */
    public String getActivityName() {
        return activityName;
    }

    /**
     * activityName.
     *
     * @param activityName the activityName to set
     * @since JDK 1.6
     */
    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    /**
     * planType.
     *
     * @return the planType
     * @since JDK 1.6
     */
    public Integer getPlanType() {
        return planType;
    }

    /**
     * planType.
     *
     * @param planType the planType to set
     * @since JDK 1.6
     */
    public void setPlanType(Integer planType) {
        this.planType = planType;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public Integer getActivityType() {
        return activityType;
    }

    public void setActivityType(Integer activityType) {
        this.activityType = activityType;
    }

    public String getActivityUrl() {
        return activityUrl;
    }

    public void setActivityUrl(String activityUrl) {
        this.activityUrl = activityUrl;
    }

    public Long getOperatorActivityId() {
        return operatorActivityId;
    }

    public void setOperatorActivityId(Long operatorActivityId) {
        this.operatorActivityId = operatorActivityId;
    }

    public Date getReleaseTime() {
        return releaseTime;
    }

    public void setReleaseTime(Date releaseTime) {
        this.releaseTime = releaseTime;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Long getSlotId() {
        return slotId;
    }

    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    
    public Integer getSource() {
        return source;
    }

    
    public void setSource(Integer source) {
        this.source = source;
    }

}
