/**
 * Project Name:media-biz<br>
 * File Name:ReqAccount.java<br>
 * Package Name:cn.com.duiba.tuia.media.model.req<br>
 * Date:2016年9月30日下午2:56:35<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.media.model.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

import org.apache.commons.lang.builder.ToStringBuilder;

import cn.com.duiba.tuia.media.api.dto.BaseQueryDto;

/**
 * ClassName: ReqAccount <br/>
 * date: 2016年9月30日 下午2:56:35 <br/>
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
@ApiModel
public class ReqAccount extends BaseQueryDto {

    private static final long serialVersionUID = 1L;

    /** 邮箱. */
    @ApiModelProperty(value = "邮箱", required = false)
    private String            email;

    /** 邮箱状态:0：未验证;1：已验证. */
    @ApiModelProperty(value = "邮箱状态", required = true)
    @NotNull(message = "邮箱状态不能为空")
    private Integer           emailStatus;

    /** 审核状态:0：审核中;1：审核通过;2：审核拒绝. */
    @ApiModelProperty(value = "审核状态", required = true)
    @NotNull(message = "审核状态不能为空")
    private Integer           checkStatus;

    /**
     * email.
     *
     * @return the email
     * @since JDK 1.6
     */
    public String getEmail() {
        return email;
    }

    /**
     * email.
     *
     * @param email the email to set
     * @since JDK 1.6
     */
    public void setEmail(String email) {
        this.email = email;
    }

    /**
     * emailStatus.
     *
     * @return the emailStatus
     * @since JDK 1.6
     */
    public Integer getEmailStatus() {
        return emailStatus;
    }

    /**
     * emailStatus.
     *
     * @param emailStatus the emailStatus to set
     * @since JDK 1.6
     */
    public void setEmailStatus(Integer emailStatus) {
        this.emailStatus = emailStatus;
    }

    /**
     * checkStatus.
     *
     * @return the checkStatus
     * @since JDK 1.6
     */
    public Integer getCheckStatus() {
        return checkStatus;
    }

    /**
     * checkStatus.
     *
     * @param checkStatus the checkStatus to set
     * @since JDK 1.6
     */
    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
