/**
 * Project Name:media-biz<br>
 * File Name:ReqChangeEmailToken.java<br>
 * Package Name:cn.com.duiba.tuia.media.model.req<br>
 * Date:2016年10月17日下午7:04:40<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.media.model.req;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.hibernate.validator.constraints.Email;
import org.hibernate.validator.constraints.NotBlank;

/**
 * ClassName: ReqChangeEmailToken <br/>
 * date: 2016年10月17日 下午7:04:40 <br/>
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
public class ReqEmailToken {

    @NotBlank(message = "token不能为空")
    private String token;

    @NotBlank(message = "邮箱不能为空")
    @Email(message = "邮箱格式不正确")
    private String email;

    /**
     * email.
     *
     * @return the email
     * @since JDK 1.6
     */
    public String getEmail() {
        return email;
    }

    /**
     * email.
     *
     * @param email the email to set
     * @since JDK 1.6
     */
    public void setEmail(String email) {
        this.email = email;
    }

    /**
     * token.
     *
     * @return the token
     * @since JDK 1.6
     */
    public String getToken() {
        return token;
    }

    /**
     * token.
     *
     * @param token the token to set
     * @since JDK 1.6
     */
    public void setToken(String token) {
        this.token = token;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
