/**
 * Project Name:media-biz<br/>
 * File Name:ReqUpdateCompanyInfo.java<br/>
 * Package Name:cn.com.duiba.tuia.media.model.req<br/>
 * Date:2017年1月22日下午3:55:22<br/>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.media.model.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

import org.hibernate.validator.constraints.NotBlank;

/**
 * ClassName:ReqUpdateCompanyInfo <br/>
 * Reason: 媒体账户修改公司信息请求参数 <br/>
 * Date: 2017年1月22日 下午3:55:22 <br/>
 * 
 * @author ZFZ
 * @version
 * @since JDK 1.6
 * @see
 */

@ApiModel
public class ReqUpdateCompanyInfo extends BaseBankInfo implements Serializable{

    /**
     * @since JDK 1.6
     */
    private static final long serialVersionUID = 7369014102640132236L;

    /** 财务公司名称 */
    @ApiModelProperty(value = "财务公司名称", required = true)
    @NotBlank(message = "财务公司名称不可为空")
    private String financeCompanyName;

    /** 营业执照号 */
    @ApiModelProperty(value = "营业执照号", required = true)
    @NotBlank(message = "营业执照号不可为空")
    private String businessLicenseId;

    /** 营业执照文件地址 */
    @ApiModelProperty(value = "营业执照文件地址", required = true)
    @NotBlank(message = "营业执照文件地址不可为空")
    private String businessLicenseUrl;

    /**
     * financeCompanyName.
     *
     * @return the financeCompanyName
     * @since JDK 1.6
     */
    public String getFinanceCompanyName() {
        return financeCompanyName;
    }

    /**
     * financeCompanyName.
     *
     * @param financeCompanyName the financeCompanyName to set
     * @since JDK 1.6
     */
    public void setFinanceCompanyName(String financeCompanyName) {
        this.financeCompanyName = financeCompanyName;
    }

    /**
     * businessLicenseId.
     *
     * @return the businessLicenseId
     * @since JDK 1.6
     */
    public String getBusinessLicenseId() {
        return businessLicenseId;
    }

    /**
     * businessLicenseId.
     *
     * @param businessLicenseId the businessLicenseId to set
     * @since JDK 1.6
     */
    public void setBusinessLicenseId(String businessLicenseId) {
        this.businessLicenseId = businessLicenseId;
    }

    /**
     * businessLicenseUrl.
     *
     * @return the businessLicenseUrl
     * @since JDK 1.6
     */
    public String getBusinessLicenseUrl() {
        return businessLicenseUrl;
    }

    /**
     * businessLicenseUrl.
     *
     * @param businessLicenseUrl the businessLicenseUrl to set
     * @since JDK 1.6
     */
    public void setBusinessLicenseUrl(String businessLicenseUrl) {
        this.businessLicenseUrl = businessLicenseUrl;
    }

}
