/**
 * Project Name:media-biz<br/>
 * File Name:ReqUpdatePersonInfo.java<br/>
 * Package Name:cn.com.duiba.tuia.media.model.req<br/>
 * Date:2017年1月22日下午4:04:13<br/>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.media.model.req;

import java.io.Serializable;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.hibernate.validator.constraints.NotBlank;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * ClassName:ReqUpdatePersonInfo <br/>
 * Reason: 修改媒体个人信息请求参数. <br/>
 * Date: 2017年1月22日 下午4:04:13 <br/>
 * 
 * @author ZFZ
 * @version
 * @since JDK 1.6
 * @see
 */

@ApiModel
public class ReqUpdatePersonInfo extends BaseBankInfo implements Serializable {

    /**
     * @since JDK 1.6
     */
    private static final long serialVersionUID = -2693696386050578570L;

    /** 个人姓名 */
    @ApiModelProperty(value = "个人姓名", required = true)
    @NotBlank(message = "个人姓名不可为空")
    private String            personalName;

    /** 身份证号 */
    @ApiModelProperty(value = "身份证号", required = true)
    @NotBlank(message = "身份证号不可为空")
    private String            idCard;

    /** 身份证正面文件地址 */
    @ApiModelProperty(value = "身份证正面文件地址", required = true)
    @NotBlank(message = "身份证正面文件地址不可为空")
    private String            idCardFrontUrl;

    /** 身份证反面文件地址 */
    @ApiModelProperty(value = "身份证反面文件地址", required = true)
    @NotBlank(message = "身份证反面文件地址不可为空")
    private String            idCardBackUrl;

    /**
     * personalName.
     *
     * @return the personalName
     * @since JDK 1.6
     */
    public String getPersonalName() {
        return personalName;
    }

    /**
     * personalName.
     *
     * @param personalName the personalName to set
     * @since JDK 1.6
     */
    public void setPersonalName(String personalName) {
        this.personalName = personalName;
    }

    /**
     * idCard.
     *
     * @return the idCard
     * @since JDK 1.6
     */
    public String getIdCard() {
        return idCard;
    }

    /**
     * idCard.
     *
     * @param idCard the idCard to set
     * @since JDK 1.6
     */
    public void setIdCard(String idCard) {
        this.idCard = idCard;
    }

    /**
     * idCardFrontUrl.
     *
     * @return the idCardFrontUrl
     * @since JDK 1.6
     */
    public String getIdCardFrontUrl() {
        return idCardFrontUrl;
    }

    /**
     * idCardFrontUrl.
     *
     * @param idCardFrontUrl the idCardFrontUrl to set
     * @since JDK 1.6
     */
    public void setIdCardFrontUrl(String idCardFrontUrl) {
        this.idCardFrontUrl = idCardFrontUrl;
    }

    /**
     * idCardBackUrl.
     *
     * @return the idCardBackUrl
     * @since JDK 1.6
     */
    public String getIdCardBackUrl() {
        return idCardBackUrl;
    }

    /**
     * idCardBackUrl.
     *
     * @param idCardBackUrl the idCardBackUrl to set
     * @since JDK 1.6
     */
    public void setIdCardBackUrl(String idCardBackUrl) {
        this.idCardBackUrl = idCardBackUrl;
    }
    
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
