/**
 * Project Name:media-biz File Name:ReqUpdateVerifyInfo.java Package Name:cn.com.duiba.tuia.media.model.req
 * Date:2017年1月24日下午12:25:23 Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.media.model.req;

import java.io.Serializable;

import io.swagger.annotations.ApiModelProperty;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.hibernate.validator.constraints.Email;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

/**
 * ClassName:ReqUpdateVerifyInfo <br/>
 * Function: 请求校验信息. <br/>
 * Date: 2017年1月24日 下午12:25:23 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
public class ReqUpdateVerifyInfo implements Serializable {

    /** 序列号 */
    private static final long serialVersionUID = 3168825326380102429L;
    /** 手机号. */
    @ApiModelProperty(value = "手机号", required = false)
    @Length(min = 11, max = 11, message = "手机号必须是11位")
    private String            linkPhone;
    /** 邮箱地址. */
    @ApiModelProperty(value = "邮箱地址", required = false)
    @Email(message = "邮箱格式错误")
    private String            email;
    /** 验证码. */
    @ApiModelProperty(value = "验证码", required = false)
    @NotBlank(message = "验证码不能为空")
    private String            code;

    /**
     * linkPhone.
     *
     * @return the linkPhone
     * @since JDK 1.6
     */
    public String getLinkPhone() {
        return linkPhone;
    }

    /**
     * linkPhone.
     *
     * @param linkPhone the linkPhone to set
     * @since JDK 1.6
     */
    public void setLinkPhone(String linkPhone) {
        this.linkPhone = linkPhone;
    }

    /**
     * email.
     *
     * @return the email
     * @since JDK 1.6
     */
    public String getEmail() {
        return email;
    }

    /**
     * email.
     *
     * @param email the email to set
     * @since JDK 1.6
     */
    public void setEmail(String email) {
        this.email = email;
    }

    /**
     * code.
     *
     * @return the code
     * @since JDK 1.6
     */
    public String getCode() {
        return code;
    }

    /**
     * code.
     *
     * @param code the code to set
     * @since JDK 1.6
     */
    public void setCode(String code) {
        this.code = code;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
