/**
 * Project Name:media-biz<br>
 * File Name:ShieldStrategy.java<br>
 * Package Name:cn.com.duiba.tuia.media.model.rsp<br>
 * Date:2016年9月27日下午4:31:29<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.media.model.rsp;

import java.util.List;

import io.swagger.annotations.ApiModelProperty;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName: ShieldStrategy <br/>
 * Function: 屏蔽策略. <br/>
 * date: 2016年9月27日 下午4:31:29 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
public class RspShieldStrategy extends BaseStrategy {

    private boolean      industryFlag      = false;

    private boolean      advertiserFlag    = false;

    private boolean      advertTagNumsFlag = false;

    /** 屏蔽行业列表，中间以逗号隔开. */
    @ApiModelProperty(value = "屏蔽行业列表，中间以逗号隔开", required = false)
    private List<String> shieldIndustries;

    /** 屏蔽广告列表，中间以逗号隔开. */
    @ApiModelProperty(value = "屏蔽广告列表，中间以逗号隔开", required = false)
    private List<String> advertTagNums;

    /** 屏蔽广告主URL列表， 中间以逗号隔开. */
    @ApiModelProperty(value = "屏蔽广告主URL列表， 中间以逗号隔开", required = false)
    private List<String> shieldAdvertisers;

    public boolean isIndustryFlag() {
        return industryFlag;
    }

    public void setIndustryFlag(boolean industryFlag) {
        this.industryFlag = industryFlag;
    }

    public boolean isAdvertiserFlag() {
        return advertiserFlag;
    }

    public void setAdvertiserFlag(boolean advertiserFlag) {
        this.advertiserFlag = advertiserFlag;
    }

    public List<String> getShieldIndustries() {
        return shieldIndustries;
    }

    public void setShieldIndustries(List<String> shieldIndustries) {
        this.shieldIndustries = shieldIndustries;
    }

    public List<String> getAdvertTagNums() {
        return advertTagNums;
    }

    public void setAdvertTagNums(List<String> advertTagNums) {
        this.advertTagNums = advertTagNums;
    }

    public List<String> getShieldAdvertisers() {
        return shieldAdvertisers;
    }

    public void setShieldAdvertisers(List<String> shieldAdvertisers) {
        this.shieldAdvertisers = shieldAdvertisers;
    }

    public boolean isAdvertTagNumsFlag() {
        return advertTagNumsFlag;
    }

    public void setAdvertTagNumsFlag(boolean advertTagNumsFlag) {
        this.advertTagNumsFlag = advertTagNumsFlag;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
