package cn.com.duiba.tuia.media.parser;

import cn.com.duiba.tuia.media.api.dto.AccountDto;
import cn.com.duiba.tuia.media.api.dto.MediaAppDto;
import cn.com.duiba.tuia.media.model.IdAndName;

/**
 * @author xuyenan
 * @createTime 2016/12/28
 */
public final class IdAndNameParser {

    private IdAndNameParser() {
    }

    /**
     * IdAndName parse to MediaAppDto
     * 
     * @param idAndName
     * @return MediaAppDto
     */
    public static MediaAppDto parseToMediaAppDto(IdAndName idAndName) {
        MediaAppDto appDto = new MediaAppDto();
        appDto.setAppId(idAndName.getId());
        appDto.setAppName(idAndName.getName());
        return appDto;
    }

    /**
     * parseToAccountDto:(对象转换). <br/>
     *
     * @param idAndName
     * @return
     * @since JDK 1.6
     */
    public static AccountDto parseToAccountDto(IdAndName idAndName) {
        AccountDto accountDto = new AccountDto();
        accountDto.setMediaId(idAndName.getId());
        accountDto.setEmail(idAndName.getName());
        return accountDto;
    }
}
