package cn.com.duiba.tuia.media.remoteservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import cn.com.duiba.tuia.media.service.cacheservice.ActivityDirectAppCacheService;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import cn.com.duiba.tuia.activity.center.api.dto.ActivityType;
import cn.com.duiba.tuia.activity.center.api.remoteservice.RemoteActivityService;
import cn.com.duiba.tuia.media.api.dto.ActivitySpmDto;
import cn.com.duiba.tuia.media.api.dto.MediaAppDto;
import cn.com.duiba.tuia.media.api.dto.PageResultDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqActivityDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqIdAndType;
import cn.com.duiba.tuia.media.api.dto.rsp.RspActivityAdvertDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspActivityDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspMaterialSpecificationDto;
import cn.com.duiba.tuia.media.api.remoteservice.RemoteActivityBackendService;
import cn.com.duiba.tuia.media.model.IdAndName;
import cn.com.duiba.tuia.media.parser.IdAndNameParser;
import cn.com.duiba.tuia.media.service.ActivityAdvertService;
import cn.com.duiba.tuia.media.service.ActivityService;
import cn.com.duiba.tuia.media.service.ActivitySpmService;
import cn.com.duiba.tuia.media.service.AdvertService;
import cn.com.duiba.tuia.media.service.MediaAppActivityService;
import cn.com.duiba.tuia.media.service.MediaAppService;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * @author xuyenan
 * @createTime 2016/10/25
 */
public class RemoteActivityBackendServiceImpl extends BaseRemoteService implements RemoteActivityBackendService {

    @Autowired
    private ActivityService         activityService;

    @Autowired
    private MediaAppActivityService mediaAppActivityService;

    @Autowired
    private ActivityAdvertService   activityAdvertService;

    @Autowired
    private MediaAppService         mediaAppService;

    @Autowired
    private AdvertService           advertService;

    @Autowired
    private ActivitySpmService      activitySpmService;

    @Autowired
    private RemoteActivityService   remoteActivityService;

    @Autowired
    private ActivityDirectAppCacheService activityDirectAppCacheService;

    @Override
    public DubboResult<List<RspActivityDto>> getByActivityIds(List<Long> activityIds, int actSource) {
        try {
            List<RspActivityDto> rspActivityDtoList = activityService.getActivityByIds(activityIds, actSource);
            return DubboResult.successResult(rspActivityDtoList);
        } catch (Exception e) {
            logger.error("RemoteActivityBackendService.getByActivityIds is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<String> getActivityNameByIdAndType(Long id, Integer type) {
        try {
            String name = activityService.getActivityName(id, type);
            return DubboResult.successResult(name);
        } catch (Exception e) {
            logger.error("RemoteActivityBackendService.getActivityByIdAndType is error", e);
            return exceptionFailure(e);
        }
    }
    
    @Override
    public DubboResult<String> getActivityNameByIdAndSource(Long id, Integer source) {
        try {
            String name = activityService.getActivityNameBySource(id, source);
            return DubboResult.successResult(name);
        } catch (Exception e) {
            logger.error("RemoteActivityBackendService.getActivityByIdAndType is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<PageResultDto<RspActivityDto>> getPlanList(ReqActivityDto req) {
        try {

            // 批量查询推啊活动类型
            DubboResult<List<ActivityType>> selectResult = remoteActivityService.selectAllActivityType();
            if (selectResult.isSuccess()) {

            }

            // 组装活动类型map
            HashMap<Integer, String> actTypeMap = new HashMap<>();
            List<ActivityType> actTypeList = selectResult.getResult();
            for (ActivityType actType : actTypeList) {
                actTypeMap.put(actType.getId(), actType.getName());
            }

            int totalCount = activityService.getPlanListAmount(req);

            List<RspActivityDto> rspList = new ArrayList<>();
            List<RspActivityDto> list = activityService.getPlanList(req);
            // 筛选出推啊活动
            for (RspActivityDto dto : list) {
                if (ReqIdAndType.REQ_ACT_SOURCE_TUIA == dto.getSource()) {
                    dto.setTypeName(actTypeMap.get(dto.getType()));
                }
                if (ReqIdAndType.REQ_ACT_SOURCE_FLOW == dto.getSource()) {
                    dto.setTypeName(ReqIdAndType.REQ_ACT_SOURCE_FLOW_MINE);
                }
                rspList.add(dto);
            }

            return DubboResult.successResult(new PageResultDto<>(totalCount, list, req.getPageSize()));
        } catch (Exception e) {
            logger.error("RemoteActivityBackendService.getPlanList is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<Boolean> addActivityPlan(List<ReqIdAndType> activities, Integer actSource) {
        try {
            return DubboResult.successResult(activityService.addActivityPlan(activities, actSource));
        } catch (Exception e) {
            logger.error("RemoteActivityBackendService.addActivityPlan is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<Boolean> deleteActivityPlanBySource(Long activityId, Integer source) {
        try {
            return DubboResult.successResult(activityService.deleteActivityPlanBySource(activityId, source));
        } catch (Exception e) {
            logger.error("RemoteActivityBackendService.deleteActivityPlanBySource is error", e);
            return exceptionFailure(e);
        }
    }
    
    @Override
    public DubboResult<Boolean> deleteActivityPlan(Long activityId, Integer activityType) {
        try {
            return DubboResult.successResult(activityService.deleteActivityPlan(activityId, activityType));
        } catch (Exception e) {
            logger.error("RemoteActivityBackendService.deleteActivityPlan is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<Boolean> changeActivityPlanEnableBySource(Long activityId, Integer source, Integer enableStatus) {
        try {
            return DubboResult.successResult(activityService.changeActivityPlanEnableBySource(activityId, source,
                                                                                      enableStatus));
        } catch (Exception e) {
            logger.error("RemoteActivityBackendService.changeActivityPlanEnableBySource is error", e);
            return exceptionFailure(e);
        }
    }
    
    @Override
    public DubboResult<Boolean> changeActivityPlanEnable(Long activityId, Integer activityType, Integer enableStatus) {
        try {
            return DubboResult.successResult(activityService.changeActivityPlanEnable(activityId, activityType,
                                                                                      enableStatus));
        } catch (Exception e) {
            logger.error("RemoteActivityBackendService.changeActivityPlanEnable is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<Boolean> updateActivityPlan(ReqActivityDto reqActivityDto) {
        try {
            return DubboResult.successResult(activityService.updateActivityPlan(reqActivityDto));
        } catch (Exception e) {
            logger.error("RemoteActivityBackendService.updateActivityPlan is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<RspActivityDto> getActivityPlanDetailBySource(Long activityId, Integer source) {
        try {
            RspActivityDto rspActivityDto = activityService.getActivityPlanDetailBySource(activityId, source);
            // 查询素材列表
            rspActivityDto = activityService.getMsItemContent(rspActivityDto);
            return DubboResult.successResult(rspActivityDto);
        } catch (Exception e) {
            logger.error("RemoteActivityBackendService.getActivityPlanDetailBySource is error", e);
            return exceptionFailure(e);
        }
    }
    
    @Override
    public DubboResult<RspActivityDto> getActivityPlanDetail(Long activityId, Integer activityType) {
        try {
            RspActivityDto rspActivityDto = activityService.getActivityPlanDetail(activityId, activityType);
            // 查询素材列表
            rspActivityDto = activityService.getMsItemContent(rspActivityDto);
            return DubboResult.successResult(rspActivityDto);
        } catch (Exception e) {
            logger.error("RemoteActivityBackendService.getActivityPlanDetail is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<List<MediaAppDto>> getActivityDirectedMediaAppBySource(Long activityId, Integer source) {
        try {
            List<Long> list = activityDirectAppCacheService.getBySource(activityId, source);
            List<MediaAppDto> result = new ArrayList<>();
            if (!CollectionUtils.isEmpty(list)) {
                List<IdAndName> apps = mediaAppService.selectAppIdAndName(list);
                for (IdAndName idAndName : apps) {
                    result.add(IdAndNameParser.parseToMediaAppDto(idAndName));
                }
            }
            return DubboResult.successResult(result);
        } catch (Exception e) {
            logger.error("RemoteActivityBackendService.getActivityDirectedMediaAppBySource is error", e);
            return exceptionFailure(e);
        }
    }
    
    @Override
    public DubboResult<List<MediaAppDto>> getActivityDirectedMediaApp(Long activityId, Integer activityType) {
        try {
            List<Long> list = activityDirectAppCacheService.get(activityId, activityType);
            List<MediaAppDto> result = new ArrayList<>();
            if (!CollectionUtils.isEmpty(list)) {
                List<IdAndName> apps = mediaAppService.selectAppIdAndName(list);
                for (IdAndName idAndName : apps) {
                    result.add(IdAndNameParser.parseToMediaAppDto(idAndName));
                }
            }
            return DubboResult.successResult(result);
        } catch (Exception e) {
            logger.error("RemoteActivityBackendService.activityDirectToMediaApp is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<Boolean> activityDirectToMediaApp(Long activityId, Integer activityType,Integer source,Integer directStatus,
                                                         List<Long> appIds) {
        try {
            return DubboResult.successResult(mediaAppActivityService.activityDirectToMediaAppBySource(activityId, activityType, source, directStatus, appIds));
        } catch (Exception e) {
            logger.error("RemoteActivityBackendService.activityDirectToMediaApp is error", e);
            return exceptionFailure(e);
        }
    }
    
    @Override
    public DubboResult<Boolean> activityDirectToMediaApp(Long activityId, Integer activityType,Integer directStatus,
                                                         List<Long> appIds) {
        try {
            return DubboResult.successResult(mediaAppActivityService.activityDirectToMediaApp(activityId, activityType, directStatus, appIds));
        } catch (Exception e) {
            logger.error("RemoteActivityBackendService.activityDirectToMediaApp is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<List<RspActivityAdvertDto>> getActivityDirectedAdvertBySource(Long activityId, Integer source) {
        try {
            List<Long> list = activityAdvertService.getActivityAdvertIdsBySource(activityId, source);
            return DubboResult.successResult(advertService.getAdvertsByIds(list));
        } catch (Exception e) {
            logger.error("RemoteActivityBackendService.getActivityDirectedAdvertBySource is error", e);
            return exceptionFailure(e);
        }
    }
    
    @Override
    public DubboResult<List<RspActivityAdvertDto>> getActivityDirectedAdvert(Long activityId, Integer activityType) {
        try {
            List<Long> list = activityAdvertService.getActivityAdvertIds(activityId, activityType);
            return DubboResult.successResult(advertService.getAdvertsByIds(list));
        } catch (Exception e) {
            logger.error("RemoteActivityBackendService.getActivityDirectedAdvert is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<Boolean> activityDirectToAdvertBySource(Long activityId, Integer source, Integer directStatus,
                                                       Integer directMode, List<Long> advertIds) {
        try {
            return DubboResult.successResult(activityAdvertService.activityDirectToAdvertBySource(activityId, source, directStatus, directMode, advertIds));
        } catch (Exception e) {
            logger.error("RemoteActivityBackendService.activityDirectToAdvertBySource is error", e);
            return exceptionFailure(e);
        }
    }
    
    @Override
    public DubboResult<Boolean> activityDirectToAdvert(Long activityId, Integer activityType, Integer directStatus,
                                                       Integer directMode, List<Long> advertIds) {
        try {
            return DubboResult.successResult(activityAdvertService.activityDirectToAdvert(activityId, activityType, directStatus, directMode, advertIds));
        } catch (Exception e) {
            logger.error("RemoteActivityBackendService.activityDirectToAdvert is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<List<RspMaterialSpecificationDto>> getMsItemList() {
        try {
            return DubboResult.successResult(activityService.getMsItemList());
        } catch (Exception e) {
            logger.error("RemoteActivityBackendService.getMsItemList is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<List<RspActivityAdvertDto>> getAdvertByIds(List<Long> ids) {
        try {
            return DubboResult.successResult(advertService.getAdvertsByIds(ids));
        } catch (Exception e) {
            logger.error("RemoteActivityBackendService.getMsItemList is error", e);
            return exceptionFailure(e);
        }
    }
    
    @Override
    public DubboResult<RspActivityDto> getActivityPlan(Long activityId, Integer activityType) {
        try {
            return DubboResult.successResult(activityService.getActivityPlanDetail(activityId, activityType));
        } catch (Exception e) {
            logger.error("RemoteActivityBackendService.getActivityPlan is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<List<Long>> getActivityAdvertIds(Long activityId, Integer activityType) {
        try {
            return DubboResult.successResult(activityAdvertService.getActivityAdvertIds(activityId, activityType));
        } catch (Exception e) {
            logger.error("RemoteActivityBackendService.getActivityAdvertIds is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<List<ActivitySpmDto>> getSlotSpm(Long slotId, Integer statType) {
        try {
            return DubboResult.successResult(activitySpmService.getSlotSpm(slotId, statType));
        } catch (Exception e) {
            logger.error("RemoteActivityBackendService.getSlotSpm is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<Boolean> removeFromNewActListBySource(Long activityId, Integer source) {
        try {
            return DubboResult.successResult(activityService.changeToOldActBySource(activityId, source));
        } catch (Exception e) {
            logger.error("RemoteActivityBackendService.removeFromNewActListBySource is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<Boolean> removeFromNewActList(Long activityId, Integer activityType) {
        try {
            return DubboResult.successResult(activityService.changeToOldAct(activityId, activityType));
        } catch (Exception e) {
            logger.error("RemoteActivityBackendService.removeFromNewActList is error", e);
            return exceptionFailure(e);
        }
    }
    
    @Override
    public DubboResult<Map<Long, String>> getCacheActivityNameBySource(List<ReqIdAndType> activities) {
        try {
            return DubboResult.successResult(activityService.getCacheActivityName(activities));
        } catch (Exception e) {
            logger.error("RemoteActivityBackendService.getCacheActivityNameBySource is error", e);
            return exceptionFailure(e);
        }
    }
    
    @Override
    public DubboResult<Map<Long, String>> getCacheActivityName(List<ReqIdAndType> activities) {
        try {
            return DubboResult.successResult(activityService.getCacheActivityName(activities));
        } catch (Exception e) {
            logger.error("RemoteActivityBackendService.removeFromNewActList is error", e);
            return exceptionFailure(e);
        }
    }

    public DubboResult<List<Long>> getActivityIdsByName(String ActivityName) {
        try {
            return DubboResult.successResult(activityService.getActivityIdsByName(ActivityName));
        } catch (Exception e) {
            logger.error("RemoteActivityBackendService.getActivityIdsByName is error", e);
            return exceptionFailure(e);
        }
    }

}
