package cn.com.duiba.tuia.media.remoteservice;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import org.apache.commons.lang.time.DateUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.tuia.media.api.dto.ActivityManualPlanDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspActivityDto;
import cn.com.duiba.tuia.media.api.remoteservice.RemoteActivityManualBackendService;
import cn.com.duiba.tuia.media.dataobject.ActivityManualPlanDO;
import cn.com.duiba.tuia.media.service.ActivityManualService;
import cn.com.duiba.tuia.media.service.ActivityService;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * RemoteActivityManualBackendServiceImpl
 */
@Service
public class RemoteActivityManualBackendServiceImpl extends BaseRemoteService implements RemoteActivityManualBackendService {

    private static final String   TIME_DATE_FORMATE = "yyyy-MM-dd HH:mm:ss";

    @Autowired
    private ActivityService       activityService;
    @Autowired
    private ActivityManualService activityManualService;

    @Override
    public DubboResult<Boolean> addActivityManualPlan(ActivityManualPlanDto planDto) {
        try {
            ActivityManualPlanDO plan = new ActivityManualPlanDO();
            BeanUtils.copyProperties(planDto, plan);
            if (planDto.getReleaseTime() != null) {
                String releaseTime = buildTime(planDto.getReleaseTime()); // 构造时间格式
                plan.setReleaseTime(DateUtils.parseDate(releaseTime, new String[] { TIME_DATE_FORMATE }));
            }
            return DubboResult.successResult(activityManualService.addActivityManualPlan(plan));
        } catch (Exception e) {
            logger.error("RemoteActivityManualServiceImpl.addActivityManualPlan is error, plan=" + planDto, e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<List<ActivityManualPlanDto>> findActivityManualPlans(Long slotId) {
        try {
            List<ActivityManualPlanDto> dtoList = new ArrayList<>();
            List<ActivityManualPlanDO> list = activityManualService.findActivityManualPlans(slotId);
            for (ActivityManualPlanDO plan : list) {
                ActivityManualPlanDto planDto = new ActivityManualPlanDto();
                BeanUtils.copyProperties(plan, planDto);
                if (plan.getReleaseTime() != null) {
                    planDto.setReleaseTime(new SimpleDateFormat(TIME_DATE_FORMATE).format(plan.getReleaseTime()));
                }

                if (ActivityManualPlanDO.PLAN_TYPE_ACT == plan.getPlanType()) {

                   /*RspActivityDto activity = activityService.getActivityPlanDetail(plan.getActivityId(),
                                                                                    plan.getActivityType());*/
                    
                    RspActivityDto activity = activityService.getActivityPlanDetailBySource(plan.getActivityId(),
                                                                                            plan.getSource());

                    planDto.setActivityName(activity.getName());
                    planDto.setActivityStatus(activity.getIsEnable());
                }

                if (ActivityManualPlanDO.PLAN_TYPE_VENUE == plan.getPlanType()) {
                    planDto.setActivityStatus(RspActivityDto.ACT_ENABLE);
                }
                
                
                if (!planDto.getActivityUrl().startsWith("http")) {
                    StringBuilder builder=new StringBuilder();
                    builder.append("http:").append(planDto.getActivityUrl());
                    planDto.setActivityUrl(builder.toString());
                } 
                dtoList.add(planDto);
            }
            return DubboResult.successResult(dtoList);
        } catch (Exception e) {
            logger.error("RemoteActivityManualServiceImpl.findActivityManualPlans is error, slotId=" + slotId, e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<Boolean> modifyActivityManualPlan(ActivityManualPlanDto planDto) {
        try {
            ActivityManualPlanDO plan = new ActivityManualPlanDO();
            BeanUtils.copyProperties(planDto, plan);
            if (planDto.getReleaseTime() != null) {
                String releaseTime = buildTime(planDto.getReleaseTime()); // 构造时间格式
                plan.setReleaseTime(DateUtils.parseDate(releaseTime, new String[] { TIME_DATE_FORMATE }));
            }
            return DubboResult.successResult(activityManualService.modifyActivityManualPlan(plan));
        } catch (Exception e) {
            logger.error("RemoteActivityManualServiceImpl.modifyActivityManualPlan is error, planDto=" + planDto, e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<Boolean> removeActivityManualPlan(ActivityManualPlanDto planDto) {
        try {
            ActivityManualPlanDO plan = new ActivityManualPlanDO();
            BeanUtils.copyProperties(planDto, plan);
            if (planDto.getReleaseTime() != null) {
                String releaseTime = buildTime(planDto.getReleaseTime()); // 构造时间格式
                plan.setReleaseTime(DateUtils.parseDate(releaseTime, new String[] { TIME_DATE_FORMATE }));
            }
            return DubboResult.successResult(activityManualService.removeActivityManualPlan(plan));
        } catch (Exception e) {
            logger.error("RemoteActivityManualServiceImpl.removeActivityManualPlan is error", e);
            return exceptionFailure(e);
        }
    }

    /**
     * buildTime:(构造时间). <br/>
     *
     * @param releaseTime
     * @return
     * @since JDK 1.6
     */
    private String buildTime(String releaseTime) {
        StringBuilder builder = new StringBuilder();
        builder.append(releaseTime);
        Calendar calendar = Calendar.getInstance();
        int seconds = calendar.get(Calendar.SECOND);
        builder.append(":");
        if (seconds < 10) {
            builder.append("0" + seconds);
        } else {
            builder.append(seconds);
        }
        return builder.toString();
    }

    @Override
    public DubboResult<List<Long>> findActivityManualPlanSlot(Long activityId, Integer activityType) {
        try {
            return DubboResult.successResult(activityManualService.findActivityManualPlanSlots(activityId, activityType));
        } catch (Exception e) {
            logger.error("RemoteActivityManualServiceImpl.findActivityManualPlanSlot is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<List<Long>> findActivityManualPlanSlotBySource(Long activityId, Integer source) {
        try {
            return DubboResult.successResult(activityManualService.findActivityManualPlanSlotsBySource(activityId, source));
        } catch (Exception e) {
            logger.error("RemoteActivityManualServiceImpl.findActivityManualPlanSlot is error", e);
            return exceptionFailure(e);
        }
    }
}
