package cn.com.duiba.tuia.media.remoteservice;

import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.tuia.media.api.dto.ActivityManualPlanDto;
import cn.com.duiba.tuia.media.api.remoteservice.RemoteActivityManualService;
import cn.com.duiba.tuia.media.dataobject.ActivityManualPlanDO;
import cn.com.duiba.tuia.media.service.ActivityManualService;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * RemoteActivityManualServiceImpl
 */
@Service
public class RemoteActivityManualServiceImpl extends BaseRemoteService implements RemoteActivityManualService {

    @Autowired
    private ActivityManualService activityManualService;

    @Override
    public DubboResult<ActivityManualPlanDto> findActivityManualPlan(Long slotId) {
        try {
            ActivityManualPlanDO plan = this.activityManualService.findActivityManualPlan(slotId);
            if (plan == null) {
                return DubboResult.successResult(null);
            }
            ActivityManualPlanDto planDto = new ActivityManualPlanDto();
            BeanUtils.copyProperties(plan, planDto);
            return DubboResult.successResult(planDto);
        } catch (Exception e) {
            logger.error("RemoteActivityManualServiceImpl.findActivityManualPlan is error, slotId=" + slotId, e);
            return exceptionFailure(e);
        }
    }
}
