package cn.com.duiba.tuia.media.remoteservice;


import cn.com.duiba.tuia.media.api.dto.rsp.RspActivitySlotDto;
import cn.com.duiba.tuia.media.api.remoteservice.RemoteActivitySlotService;
import cn.com.duiba.tuia.media.dataobject.ActivitySlotDO;
import cn.com.duiba.tuia.media.service.ActivitySlotService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class RemoteActivitySlotServiceImpl extends BaseRemoteService implements RemoteActivitySlotService {
    @Autowired
    private ActivitySlotService activitySlotService;

    @Override
    public DubboResult<RspActivitySlotDto> getById(Long slotId) {
        try {
            ActivitySlotDO activitySlotDO = activitySlotService.getBySlotId(slotId);
            RspActivitySlotDto rspActivitySlotDto = new RspActivitySlotDto();
            if (activitySlotDO != null) {
                BeanUtils.copyProperties(activitySlotDO, rspActivitySlotDto);
            }
            return DubboResult.successResult(rspActivitySlotDto);
        } catch (Exception e) {
            logger.error("RemoteActivitySlotBackendService.getBySlotId is error", e);
            return exceptionFailure(e);
        }
    }
}
