package cn.com.duiba.tuia.media.remoteservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;

import cn.com.duiba.tuia.activity.center.api.dto.ActivityType;
import cn.com.duiba.tuia.activity.center.api.remoteservice.RemoteActivityService;
import cn.com.duiba.tuia.media.api.dto.PageResultDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqActivitySort;
import cn.com.duiba.tuia.media.api.dto.req.ReqIdAndType;
import cn.com.duiba.tuia.media.api.dto.rsp.RspActivityDto;
import cn.com.duiba.tuia.media.api.remoteservice.RemoteActivitySortBackendService;
import cn.com.duiba.tuia.media.dao.MaterialSpecificationItemContentDAO;
import cn.com.duiba.tuia.media.domain.ActivitySortDto;
import cn.com.duiba.tuia.media.service.ActivityService;
import cn.com.duiba.tuia.media.service.ActivitySortService;
import cn.com.duiba.tuia.media.service.ActivitySpmService;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * @author xuyenan
 * @createTime 2016/10/25
 */
public class RemoteActivitySortBackendServiceImpl extends BaseRemoteService implements RemoteActivitySortBackendService {

    @Autowired
    private ActivityService       activityService;
    @Autowired
    private ActivitySortService   activitySortService;
    @Autowired
    private ActivitySpmService    activitySpmService;
    @Autowired
    private RemoteActivityService remoteActivityService;
    @Autowired
    private MaterialSpecificationItemContentDAO materialSpecificationItemContentDAO;

    @Override
    public DubboResult<PageResultDto<RspActivityDto>> getByCondition(ReqActivitySort reqActivitySort) {
        try {

            // 批量查询推啊活动类型
            DubboResult<List<ActivityType>> selectResult = remoteActivityService.selectAllActivityType();

            // 组装活动类型map
            HashMap<Integer, String> actTypeMap = new HashMap<>();
            List<ActivityType> actTypeList = selectResult.getResult();
            for (ActivityType actType : actTypeList) {
                actTypeMap.put(actType.getId(), actType.getName());
            }

            int amount = activitySortService.selectByConditionAmount(reqActivitySort);
            reqActivitySort.setSort("activity_sort asc,gmt_modified desc");
            reqActivitySort.setRowStart(reqActivitySort.getPageSize() * (reqActivitySort.getCurrentPage() - 1));
            List<ActivitySortDto> result = activitySortService.selectByCondition(reqActivitySort);
            List<RspActivityDto> list = new ArrayList<>();
            for (ActivitySortDto activitySortDto : result) {
                //RspActivityDto dto = activityService.getActivityPlanDetail(activitySortDto.getActivityId(), activitySortDto.getActivityType());
                
                RspActivityDto dto = activityService.getActivityPlanDetailBySource(activitySortDto.getActivityId(), activitySortDto.getSource());
                if (dto == null) {
                    continue;
                }
                if (ReqIdAndType.REQ_ACT_SOURCE_TUIA == dto.getSource()) {
                    dto.setTypeName(actTypeMap.get(dto.getType()));
                }
                //dto.setItemContentAmount(materialSpecificationItemContentDAO.itemContentAmount(dto.getId(), dto.getType()));
                dto.setItemContentAmount(materialSpecificationItemContentDAO.itemContentAmountBySource(dto.getId(), dto.getSource()));
                dto.setIndex(activitySortDto.getAbsoluteSort());
                list.add(dto);
            }
            return DubboResult.successResult(new PageResultDto<>(amount, list, reqActivitySort.getPageSize()));
        } catch (Exception e) {
            logger.error("RemoteActivitySortBackendService.getByCondition is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<Boolean> addActivitySort(Long slotId, List<ReqIdAndType> idAndTypes) {
        try {
            DubboResult<Boolean> result = new DubboResult<>();
            result.setSuccess(true);
            result.setReturnCode("0");
            int successRecord = activitySortService.addActivitySort(slotId, idAndTypes);
            result.setMsg("成功添加" + successRecord + "个活动");
            return result;
        } catch (Exception e) {
            logger.error("RemoteActivitySortBackendService.addActivitySort is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<Boolean> addDefaultActivitySort(Long slotId) {
        try {
            DubboResult<Boolean> result = new DubboResult<>();
            result.setSuccess(true);
            result.setReturnCode("0");
            int successRecord = activitySortService.addDefaultActivitySort(slotId);
            result.setMsg("成功添加" + successRecord + "个活动");
            return result;
        } catch (Exception e) {
            logger.error("RemoteActivitySortBackendService.addDefaultActivitySort is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<Boolean> removeActivity(Long slotId, Long activityId, Integer activityType) {
        try {
            return DubboResult.successResult(activitySortService.deleteActivity(activityId, activityType, slotId));
        } catch (Exception e) {
            logger.error("RemoteActivitySortBackendService.removeActivity is error", e);
            return exceptionFailure(e);
        }
    }
    
    @Override
    public DubboResult<Boolean> removeActivityBySource(Long slotId, Long activityId, Integer source) {
        try {
            return DubboResult.successResult(activitySortService.deleteActivityBySource(activityId, source, slotId));
        } catch (Exception e) {
            logger.error("RemoteActivitySortBackendService.removeActivity is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<Boolean> sort(Long slotId, Long activityId, Integer activityType, int location) {
        try {
            return DubboResult.successResult(activitySortService.sortActivity(slotId, activityId, activityType, location));
        } catch (Exception e) {
            logger.error("RemoteActivitySortBackendService.sort is error", e);
            return exceptionFailure(e);
        }
    }
    
    @Override
    public DubboResult<Boolean> sortBySource(Long slotId, Long activityId, Integer source, int location) {
        try {
            return DubboResult.successResult(activitySortService.sortActivityBySource(slotId, activityId, source, location));
        } catch (Exception e) {
            logger.error("RemoteActivitySortBackendService.sort is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<List<RspActivityDto>> getActivityByApp(Long appId) {
        try {
            return DubboResult.successResult(activitySortService.getActivityForRecommendByApp(appId));
        } catch (Exception e) {
            logger.error("RemoteActivitySortBackendService.getActivityByApp is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<List<RspActivityDto>> getActivityBySlotNew(Long slotId) {
        try {
            return DubboResult.successResult(activitySortService.getActivityForRecommendBySlot(slotId));
        } catch (Exception e) {
            logger.error("RemoteActivitySortBackendService.getActivityBySlotNew is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<List<RspActivityDto>> getActivityForCenter(Long slotId) {
        try {
            return DubboResult.successResult(activitySortService.getActivityForCenter(slotId));
        } catch (Exception e) {
            logger.error("RemoteActivitySortBackendService.getActivityBySlot is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<List<Long>> getActivityIdForCenter(int count) {
        try {
            return DubboResult.successResult(activitySpmService.getTuiaActivityIdList(count));
        } catch (Exception e) {
            logger.error("RemoteActivitySortBackendService.getActivityIdForCenter is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<List<RspActivityDto>> getEngineActivityList() {
        try {
            return DubboResult.successResult(activitySortService.getEngineActivityList());
        } catch (Exception e) {
            logger.error("RemoteActivitySortBackendService.getEngineActivityList is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<List<RspActivityDto>> getNewActivityList() {
        try {
            return DubboResult.successResult(activitySortService.getNewActivityList());
        } catch (Exception e) {
            logger.error("RemoteActivitySortBackendService.getNewActivityList is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<List<RspActivityDto>> getDefaultActivityList() {
        try {
            return DubboResult.successResult(activitySortService.getDefaultActivityList());
        } catch (Exception e) {
            logger.error("RemoteActivitySortBackendService.getDefaultActivityList is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<List<RspActivityDto>> getActivityPlanDetailList(List<Long> ids) {
        try {
            List<RspActivityDto> activityList = activityService.getActivityByIds(ids, null);
            for (RspActivityDto activityDto : activityList) {
                activityService.getMsItemContent(activityDto);
            }
            return DubboResult.successResult(activityList);
        } catch (Exception e) {
            logger.error("RemoteActivitySortBackendService.getActivityPlanDetailList is error", e);
            return exceptionFailure(e);
        }
    }
}
