package cn.com.duiba.tuia.media.remoteservice;

import java.util.List;

import cn.com.duiba.tuia.media.service.ActivityService;
import org.springframework.beans.factory.annotation.Autowired;

import cn.com.duiba.tuia.media.api.dto.rsp.RspActivityDto;
import cn.com.duiba.tuia.media.api.remoteservice.RemoteActivitySortService;
import cn.com.duiba.tuia.media.service.ActivitySortService;
import cn.com.duiba.tuia.media.service.ActivitySpmService;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName: RemoteActivitySortServiceImpl <br/>
 *
 * @author songjiaxing
 * @version 
 * @since JDK 1.6
 */
public class RemoteActivitySortServiceImpl extends BaseRemoteService implements RemoteActivitySortService {

    @Autowired
    private ActivitySortService activitySortService;
    @Autowired
    private ActivitySpmService  activitySpmService;
    @Autowired
    private ActivityService activityService;

    @Override
    public DubboResult<List<RspActivityDto>> getActivityForCenter(Long slotId) {
        try {
            return DubboResult.successResult(activitySortService.getActivityForCenter(slotId));
        } catch (Exception e) {
            logger.error("RemoteActivitySortService.getActivityForCenter is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<List<Long>> getActivityIdForCenter(int count) {
        try {
            return DubboResult.successResult(activitySpmService.getTuiaActivityIdList(count));
        } catch (Exception e) {
            logger.error("RemoteActivitySortService.getActivityIdForCenter is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<List<RspActivityDto>> getActivityBySlotNew(Long slotId) {
        try {
            return DubboResult.successResult(activitySortService.getActivityForRecommendBySlot(slotId));
        } catch (Exception e) {
            logger.error("RemoteActivitySortBackendService.getActivityBySlotNew is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<List<RspActivityDto>> getEngineActivityList() {
        try {
            return DubboResult.successResult(activitySortService.getEngineActivityList());
        } catch (Exception e) {
            logger.error("RemoteActivitySortBackendService.getEngineActivityList is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<List<RspActivityDto>> getNewActivityList() {
        try {
            return DubboResult.successResult(activitySortService.getNewActivityList());
        } catch (Exception e) {
            logger.error("RemoteActivitySortBackendService.getNewActivityList is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<List<RspActivityDto>> getDefaultActivityList() {
        try {
            return DubboResult.successResult(activitySortService.getDefaultActivityList());
        } catch (Exception e) {
            logger.error("RemoteActivitySortBackendService.getDefaultActivityList is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<List<RspActivityDto>> getActivityPlanDetailList(List<Long> ids) {
        try {
            List<RspActivityDto> activityList = activityService.getActivityByIds(ids, null);
            for (RspActivityDto activityDto : activityList) {
                activityService.getMsItemContent(activityDto);
            }
            return DubboResult.successResult(activityList);
        } catch (Exception e) {
            logger.error("RemoteActivitySortBackendService.getActivityPlanDetailList is error", e);
            return exceptionFailure(e);
        }
    }

}
