package cn.com.duiba.tuia.media.remoteservice;


import cn.com.duiba.tuia.media.api.dto.MaterialCtrDto;
import cn.com.duiba.tuia.media.api.remoteservice.RemoteMaterialSpecificationService;
import cn.com.duiba.tuia.media.service.MaterialCtrService;
import cn.com.duiba.tuia.media.service.MaterialSpecificationService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

public class RemoteMaterialSpecificationServiceImpl extends BaseRemoteService implements RemoteMaterialSpecificationService{
    @Autowired
    private MaterialSpecificationService materialSpecificationService;

    @Autowired
    private MaterialCtrService materialCtrService;

    @Override
    public DubboResult<List<MaterialCtrDto>> getMaterialCtrBySlotActivity(Long slotId, Long activityId, Integer source) {
        try {
            return DubboResult.successResult(materialCtrService.getMaterialCtrBySlotActivityAndSource(slotId, activityId, source));
        } catch (Exception e) {
            logger.error("RemoteMaterialSpecificationBackendService.getMaterialCtrBySlotActivityBySource is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<Boolean> changeMsItemContentStatus(Long materialId) {
        try {
            return DubboResult.successResult(materialSpecificationService.changeMsItemContentStatus(materialId));
        } catch (Exception e) {
            logger.error("RemoteMaterialSpecificationBackendService.changeMsItemContentStatus is error", e);
            return exceptionFailure(e);
        }
    }
}
