/**
 * Project Name:media-biz<br>
 * File Name:RemoteMediaBackendServiceImpl.java<br>
 * Package Name:cn.com.duiba.tuia.media.remoteservice<br>
 * Date:2016年10月10日上午10:13:09<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.media.remoteservice;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;

import cn.com.duiba.tuia.media.api.dto.AccountDto;
import cn.com.duiba.tuia.media.api.dto.PageResultDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqGetAccountByPageDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspAccountBaseDto;
import cn.com.duiba.tuia.media.api.remoteservice.RemoteMediaBackendService;
import cn.com.duiba.tuia.media.bo.AccountBackendBO;
import cn.com.duiba.tuia.media.service.AccountService;
import cn.com.duiba.tuia.media.service.impl.MediaCacheService;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName: RemoteMediaBackendServiceImpl <br/>
 * date: 2016年10月10日 上午10:13:09 <br/>
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
public class RemoteMediaBackendServiceImpl extends BaseRemoteService implements RemoteMediaBackendService {

    @Autowired
    private AccountService    accountService;

    @Autowired
    private AccountBackendBO  accountBackendBO;

    @Autowired
    private MediaCacheService mediaCacheService;

    @Override
    public DubboResult<PageResultDto<RspAccountBaseDto>> getMediasByPage(ReqGetAccountByPageDto req) {
        try {
            return DubboResult.successResult(accountService.pageQuery(req));
        } catch (Exception e) {
            logger.error("RemoteMediaBackendService.getMediasByPage is error, the param={}", req);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<AccountDto> getMediaByMediaId(long mediaId) {
        try {
            return DubboResult.successResult(accountService.selectByMediaId(mediaId));
        } catch (Exception e) {
            logger.error("RemoteMediaBackendService.getMediaByMediaId error");
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<Boolean> updateFreezeStatus(long mediaId, int checkType, String reason) {
        try {
            return DubboResult.successResult(accountBackendBO.updateFreezeStatus(mediaId, checkType, reason));
        } catch (Exception e) {
            logger.error("RemoteMediaBackendService.updateFreezeStatus error");
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<AccountDto> selectAccountByEmail(String email) {
        try {
            return DubboResult.successResult(accountBackendBO.selectAccountByEmail(email));
        } catch (Exception e) {
            logger.error("RemoteMediaBackendService.selectIdByEmail error");
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<List<AccountDto>> selectAccountByIds(List<Long> mediaIds) {
        try {
            return DubboResult.successResult(accountBackendBO.selectAccountByIds(mediaIds));
        } catch (Exception e) {
            logger.error("RemoteMediaBackendService.selectIdByEmail error");
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<AccountDto> selectAccountCacheById(Long mediaId) {
        try {
            return DubboResult.successResult(mediaCacheService.getAccountCacheById(mediaId));
        } catch (Exception e) {
            logger.error("RemoteMediaBackendService.selectAccountCacheById is error, the param={}", mediaId);
            return exceptionFailure(e);
        }
    }
}
