package cn.com.duiba.tuia.media.remoteservice;

import java.util.ArrayList;
import java.util.List;

import cn.com.duiba.tuia.media.api.dto.ActivitySpmDto;
import cn.com.duiba.tuia.media.api.dto.MediaAppDto;
import cn.com.duiba.tuia.media.model.IdAndName;
import cn.com.duiba.tuia.media.parser.IdAndNameParser;
import cn.com.duiba.tuia.media.service.ActivitySpmService;
import cn.com.duiba.tuia.media.service.MediaAppService;
import cn.com.duiba.tuia.media.service.cacheservice.ActivityDirectAppCacheService;
import org.springframework.beans.factory.annotation.Autowired;

import cn.com.duiba.tuia.media.api.dto.rsp.RspActivityDto;
import cn.com.duiba.tuia.media.api.remoteservice.RemoteTuiaActivityService;
import cn.com.duiba.tuia.media.service.ActivityAdvertService;
import cn.com.duiba.tuia.media.service.ActivityService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.util.CollectionUtils;


public class RemoteTuiaActivityServiceImpl extends BaseRemoteService implements RemoteTuiaActivityService {

    @Autowired
    private ActivitySpmService activitySpmService;
    
    @Autowired
    private ActivityAdvertService   activityAdvertService;

    @Autowired
    private ActivityDirectAppCacheService activityDirectAppCacheService;

    @Autowired
    private MediaAppService mediaAppService;

    @Autowired
    private ActivityService         activityService;

    @Override
    public DubboResult<List<MediaAppDto>> getActivityDirectedMediaApp(Long activityId, Integer source) {
        try {
            List<Long> list = activityDirectAppCacheService.getBySource(activityId, source);
            List<MediaAppDto> result = new ArrayList<>();
            if (!CollectionUtils.isEmpty(list)) {
                List<IdAndName> apps = mediaAppService.selectAppIdAndName(list);
                for (IdAndName idAndName : apps) {
                    result.add(IdAndNameParser.parseToMediaAppDto(idAndName));
                }
            }
            return DubboResult.successResult(result);
        } catch (Exception e) {
            logger.error("RemoteActivityBackendService.getActivityDirectedMediaAppBySource is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<RspActivityDto> getActivityPlan(Long activityId, Integer source) {
        try {
            return DubboResult.successResult(activityService.getActivityPlanDetailBySource(activityId, source));
        } catch (Exception e) {
            logger.error("RemoteActivityBackendService.getActivityPlan is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<List<Long>> getActivityAdvertIds(Long activityId, Integer source) {
        try {
            return DubboResult.successResult(activityAdvertService.getActivityAdvertIdsBySource(activityId, source));
        } catch (Exception e) {
            logger.error("RemoteActivityBackendService.getActivityAdvertIds is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<List<ActivitySpmDto>> getSlotSpm(Long slotId, Integer statType) {
        try {
            return DubboResult.successResult(activitySpmService.getSlotSpm(slotId, statType));
        } catch (Exception e) {
            logger.error("RemoteActivityBackendService.getSlotSpm is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<Boolean> removeFromNewActList(Long activityId, Integer source) {
        try {
            return DubboResult.successResult(activityService.changeToOldActBySource(activityId, source));
        } catch (Exception e) {
            logger.error("RemoteActivityBackendService.removeFromNewActListBySource is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<RspActivityDto> getActivityPlanDetail(Long activityId, Integer source) {
        try {
            RspActivityDto rspActivityDto = activityService.getActivityPlanDetailBySource(activityId, source);
            // 查询素材列表
            rspActivityDto = activityService.getMsItemContent(rspActivityDto);
            return DubboResult.successResult(rspActivityDto);
        } catch (Exception e) {
            logger.error("RemoteActivityBackendService.getActivityPlanDetailBySource is error", e);
            return exceptionFailure(e);
        }
    }

}
