package cn.com.duiba.tuia.media.service;

import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;

import java.util.List;

/**
 * @author xuyenan
 * @createTime 2016/12/23
 */
public interface ActivityAdvertService {

    /**
     * 活动定向到广告券
     *
     * @param activityId 活动ID
     * @param activityType 活动类型
     * @param directStatus 状态
     * @param directMode 定向模式
     * @param advertIds 广告券ID列表
     * @return Boolean
     */
    Boolean activityDirectToAdvert(Long activityId, Integer activityType, Integer directStatus, Integer directMode, List<Long> advertIds) throws TuiaMediaException;

    /**
     * 活动定向到广告券
     *
     * @param activityId 活动ID
     * @param source 活动来源
     * @param directStatus 状态
     * @param directMode 定向模式
     * @param advertIds 广告券ID列表
     * @return Boolean
     */
    Boolean activityDirectToAdvertBySource(Long activityId, Integer source, Integer directStatus, Integer directMode, List<Long> advertIds) throws TuiaMediaException;
    
    /**
     * 查询活动定向的广告列表
     *
     * @param activityId
     * @param activityType
     * @return ID列表
     */
    List<Long> getActivityAdvertIds(Long activityId, Integer activityType) throws TuiaMediaException;
    
    /**
     * 查询活动定向的广告列表
     *
     * @param activityId
     * @param source
     * @return ID列表
     */
    List<Long> getActivityAdvertIdsBySource(Long activityId, Integer source) throws TuiaMediaException;
}
