package cn.com.duiba.tuia.media.service;

import java.util.List;

import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dataobject.ActivityManualPlanDO;

/**
 * ActivityManualService
 */
public interface ActivityManualService {

    /**
     * @param manualPlan
     * @return boolean
     */
    boolean addActivityManualPlan(ActivityManualPlanDO manualPlan) throws TuiaMediaException;

    /**
     * @param manualPlan
     * @return boolean
     */
    boolean modifyActivityManualPlan(ActivityManualPlanDO manualPlan) throws TuiaMediaException;
    
    /**
     * @param slotId
     * @return
     */
    ActivityManualPlanDO findActivityManualPlan(Long slotId) throws TuiaMediaException;

    /**
     * @param slotId
     * @return
     */
    List<ActivityManualPlanDO> findActivityManualPlans(Long slotId) throws TuiaMediaException;

    /**
     * @param manualPlan
     * @return
     * @throws TuiaMediaException
     */
    boolean removeActivityManualPlan(ActivityManualPlanDO manualPlan) throws TuiaMediaException;

    /**
     * @param activityId
     * @param activityType
     * @return
     * @throws TuiaMediaException
     */
    List<Long> findActivityManualPlanSlots(Long activityId, Integer activityType) throws TuiaMediaException;
    
    /**
     * @param activityId
     * @param activityType
     * @return
     * @throws TuiaMediaException
     */
    List<Long> findActivityManualPlanSlotsBySource(Long activityId, Integer source) throws TuiaMediaException;
}
