package cn.com.duiba.tuia.media.service;

import java.util.List;
import java.util.Map;

import cn.com.duiba.tuia.media.api.dto.req.ReqActivityDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqIdAndType;
import cn.com.duiba.tuia.media.api.dto.rsp.RspActivityDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspMaterialSpecificationDto;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.domain.ActivityDto;

/**
 * @author xuyenan
 * @createTime 2016/12/21
 */
public interface ActivityService {

    /**
     * 活动计划列表
     *
     * @param req 查询条件
     * @return 活动列表
     */
    List<RspActivityDto> getPlanList(ReqActivityDto req) throws TuiaMediaException;

    /**
     * 数量计算
     * 
     * @param req 查询条件
     * @return 数量
     */
    int getPlanListAmount(ReqActivityDto req) throws TuiaMediaException;

    /**
     * 添加活动计划
     * 
     * @param activities 活动列表
     * @param actSource 活动来源 0-兑吧 1-推啊
     * @return Boolean
     */
    Boolean addActivityPlan(List<ReqIdAndType> activities, Integer actSource) throws TuiaMediaException;

    /**
     * 编辑活动计划
     * 
     * @param reqActivityDto 活动信息
     * @return Boolean
     */
    Boolean updateActivityPlan(ReqActivityDto reqActivityDto) throws TuiaMediaException;

    /**
     * 活动计划明细
     * 
     * @param activityId 活动ID
     * @param activityType 活动类型
     * @return RspActivityDto
     */
    RspActivityDto getActivityPlanDetail(Long activityId, Integer activityType) throws TuiaMediaException;
    
    /**
     * 活动计划明细
     * 
     * @param activityId 活动ID
     * @param source 活动来源
     * @return RspActivityDto
     */
    RspActivityDto getActivityPlanDetailBySource(Long activityId, Integer source) throws TuiaMediaException;
    
    /**
     * 活动计划明细
     *
     * @author songjiaxing
     * @param activityIds 活动ID
     * @param activityTypes 活动类型
     * @return List<RspActivityDto>
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    List<RspActivityDto>  getActivityPlanDetail4List(List<Long> activityIds, List<Integer> activityTypes) throws TuiaMediaException;
    
    /**
     * 活动计划明细(by 活动来源)
     *
     * @author songjiaxing
     * @param activityIds 活动ID
     * @param sources 活动类型
     * @return List<RspActivityDto>
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    List<RspActivityDto>  getActivityPlanDetail4ListBySource(List<Long> activityIds, List<Integer> sources) throws TuiaMediaException;
    
    /**
     * 改变开启状态:开启或关闭
     *
     * @param activityId 活动ID
     * @param activityType 活动类型
     * @param enableStatus 启用状态
     * @return Boolean
     */
    Boolean changeActivityPlanEnable(Long activityId, Integer activityType, Integer enableStatus) throws TuiaMediaException;

    /**
     * 改变开启状态:开启或关闭
     *
     * @param activityId 活动ID
     * @param source 活动来源
     * @param enableStatus 启用状态
     * @return Boolean
     */
    Boolean changeActivityPlanEnableBySource(Long activityId, Integer source, Integer enableStatus) throws TuiaMediaException;
    
    /**
     * 删除活动计划
     * 
     * @param activityId 活动ID
     * @param activityType 活动类型
     * @return Boolean
     */
    Boolean deleteActivityPlan(Long activityId, Integer activityType) throws TuiaMediaException;
    
    /**
     * 删除活动计划
     * 
     * @param activityId 活动ID
     * @param source 活动来源
     * @return Boolean
     */
    Boolean deleteActivityPlanBySource(Long activityId, Integer source) throws TuiaMediaException;

    /**
     * 根据活动ID获取列表
     *
     * @param ids 活动ID列表
     * @param actSource 活动来源
     * @return 活动列表
     */
    List<RspActivityDto> getActivityByIds(List<Long> ids, Integer actSource) throws TuiaMediaException;

    /**
     * 新增活动，兑吧同步
     *
     * @param activityDto 活动
     * @return Boolean
     */
    Boolean insertActivity(ActivityDto activityDto) throws TuiaMediaException;

    /**
     * 更新活动，兑吧同步
     * 
     * @param activityDto 活动
     * @return Boolean
     */
    Boolean updateActivity(ActivityDto activityDto) throws TuiaMediaException;

    /**
     * 删除活动，兑吧同步
     * 
     * @param activityId 活动ID
     * @param activityType 活动类型
     * @return Boolean
     */
    Boolean deleteActivity(Long activityId, Integer activityType) throws TuiaMediaException;
    
    /**
     * 删除活动，兑吧同步
     * 
     * @param activityId 活动ID
     * @param source 活动来源
     * @return Boolean
     */
    Boolean deleteActivityBySource(Long activityId, Integer source) throws TuiaMediaException;

    /**
     * 获取活动名称
     * 
     * @param activityId 活动ID
     * @param activityType 活动类型
     * @return 活动名称
     */
    String getActivityName(Long activityId, Integer activityType) throws TuiaMediaException;
    
    /**
     * 获取活动名称
     * 
     * @param activityId 活动ID
     * @param source 活动来源
     * @return 活动名称
     */
    String getActivityNameBySource(Long activityId, Integer source) throws TuiaMediaException;

    /**
     * 查询活动创意列表
     *
     * @param rspActivityDto 活动
     * @return 活动
     */
    RspActivityDto getMsItemContent(RspActivityDto rspActivityDto) throws TuiaMediaException;

    /**
     * 根据名称模糊查询ID列表
     *
     * @param name 名称
     * @return ID列表
     */
    List<Long> getIdsByName(String name) throws TuiaMediaException;

    /**
     * 编辑活动计划时查询所有规格列表
     * 
     * @return 规格列表
     */
    List<RspMaterialSpecificationDto> getMsItemList() throws TuiaMediaException;

    /**
     * 获取投放链接
     * 
     * @param activityAppId
     * @param adslotId
     * @return
     * @throws TuiaMediaException
     */
    String getActivityUrl(Long activityAppId, Long adslotId) throws TuiaMediaException;

    /**
     * 将活动从试投列表中移除
     * 
     * @param activityId 活动ID
     * @param activityType 活动类型
     * @return Boolean
     */
    Boolean changeToOldAct(Long activityId, Integer activityType) throws TuiaMediaException;
    
    /**
     * 将活动从试投列表中移除
     * 
     * @param activityId 活动ID
     * @param source 活动来源
     * @return Boolean
     */
    Boolean changeToOldActBySource(Long activityId, Integer source) throws TuiaMediaException;

    /**
     * 将所有开启的活动加到人工投放列表中
     * 
     * @return Boolean
     */
    Boolean addActivityToManualList() throws TuiaMediaException;
    
    /**
     * 
     * getCacheActivityName:(这里用一句话描述这个方法的作用). <br/>
     *
     * @param activities
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    Map<Long,String> getCacheActivityName(List<ReqIdAndType> activities)throws TuiaMediaException;
    
    /**
     * 
     * getActivityIdsByName:(通过活动名称查询活动IDS). <br/>
     *
     * @param activityName
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    List<Long> getActivityIdsByName(String activityName)throws TuiaMediaException;

    /**
     * 获取活动
     * 
     * @param source
     * @param limit
     * @return
     * @throws TuiaMediaException
     */
    List<Long> getActivityBySource(int source, int limit) throws TuiaMediaException;

}
