package cn.com.duiba.tuia.media.service;

import java.util.List;

import cn.com.duiba.tuia.media.api.dto.req.ReqActivitySlotDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqCopySlot;
import cn.com.duiba.tuia.media.api.dto.rsp.RspActivitySlotDto;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dataobject.ActivitySlotDO;

/**
 * @author xuyenan
 * @createTime 2016/12/21
 */
public interface ActivitySlotService {

    /**
     * 添加广告位
     *
     * @param slotIds 广告位ID列表
     * @return Boolean
     */
    Boolean addSlots(List<Long> slotIds) throws TuiaMediaException;

    /**
     * 删除广告位
     * 
     * @param slotId 广告位ID
     * @return Boolean
     */
    Boolean deleteSlot(Long slotId) throws TuiaMediaException;

    /**
     * 获取广告位列表
     * 
     * @param req 查询条件
     * @return 广告位列表
     */
    List<RspActivitySlotDto> getList(ReqActivitySlotDto req) throws TuiaMediaException;

    /**
     * 获取数量
     * 
     * @param req 查询条件
     * @return 数量
     */
    int getListAmount(ReqActivitySlotDto req) throws TuiaMediaException;

    /**
     * 查询广告位
     * 
     * @param slotId 广告位ID
     * @return 广告位
     */
    ActivitySlotDO getBySlotId(Long slotId) throws TuiaMediaException;

    /**
     * 更新定制广告定向模式
     *
     * @param slotId 广告ID
     * @param directMode 定向模式
     * @return Boolean
     */
    Boolean updateDirectMode(Long slotId, Integer directMode) throws TuiaMediaException;

    /**
     * copySlot:(拷贝广告位). <br/>
     *
     * @param req
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    Boolean copySlot(ReqCopySlot req) throws TuiaMediaException;
}
