package cn.com.duiba.tuia.media.service;

import java.util.List;

import cn.com.duiba.tuia.media.api.dto.req.ReqActivitySort;
import cn.com.duiba.tuia.media.api.dto.req.ReqIdAndType;
import cn.com.duiba.tuia.media.api.dto.rsp.RspActivityDto;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.domain.ActivitySortDto;

/**
 * Function: ActivitySortService
 *
 * @author xuyenan
 * @createTime 2016/10/24
 */
public interface ActivitySortService {

    /**
     * selectByCondition:(根据条件查询). <br/>
     *
     * @author ZFZ
     * @param reqActivitySort
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    List<ActivitySortDto> selectByCondition(ReqActivitySort reqActivitySort) throws TuiaMediaException;

    /**
     * selectByConditionAmount:(根据条件查询时的数量). <br/>
     *
     * @author ZFZ
     * @param reqActivitySort
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    int selectByConditionAmount(ReqActivitySort reqActivitySort) throws TuiaMediaException;

    /**
     * deleteActivity:(移除定制活动). <br/>
     *
     * @author ZFZ
     * @param slotId
     * @param activityId
     * @param activityType
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    boolean deleteActivity(Long activityId, Integer activityType, Long slotId) throws TuiaMediaException;
    
    /**
     * deleteActivity:(移除定制活动). <br/>
     *
     * @author ZFZ
     * @param slotId
     * @param activityId
     * @param source
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    boolean deleteActivityBySource(Long activityId, Integer source, Long slotId) throws TuiaMediaException;

    /**
     * 给活动推荐引擎提供的接口：根据媒体查询有效活动
     * 
     * @param appId
     * @return
     * @throws TuiaMediaException
     */
    List<RspActivityDto> getActivityForRecommendByApp(Long appId) throws TuiaMediaException;

    /**
     * 给活动推荐引擎提供的接口：根据媒体广告位查询有效活动
     * 
     * @param slotId
     * @return
     * @throws TuiaMediaException
     */
    List<RspActivityDto> getActivityForRecommendBySlot(Long slotId) throws TuiaMediaException;

    /**
     * addActivitySort
     * 
     * @param slotId
     * @param idAndTypes
     * @return 成功条数
     */
    int addActivitySort(Long slotId, List<ReqIdAndType> idAndTypes);

    /**
     * addDefaultActivitySort
     * 
     * @param slotId
     * @return 成功条数
     */
    int addDefaultActivitySort(Long slotId);

    /**
     * sortActivity
     * 
     * @param slotId
     * @param activityId
     * @param activityType
     * @param destLocation
     * @return
     * @throws TuiaMediaException
     */
    boolean sortActivity(Long slotId, Long activityId, Integer activityType, int destLocation)
                                                                                              throws TuiaMediaException;
    
    /**
     * sortActivityBySource
     * 
     * @param slotId
     * @param activityId
     * @param source
     * @param destLocation
     * @return
     * @throws TuiaMediaException
     */
    boolean sortActivityBySource(Long slotId, Long activityId, Integer source, int destLocation)
                                                                                              throws TuiaMediaException;

    /**
     * 给活动中心提供的查询接口
     *
     * @param slotId 广告位ID，暂时没用到，以后可能会用
     * @return 活动列表
     */
    List<RspActivityDto> getActivityForCenter(Long slotId) throws TuiaMediaException;

    /**
     * 获取引擎投放列表
     *
     * @return 活动列表
     */
    List<RspActivityDto> getEngineActivityList() throws TuiaMediaException;

    /**
     * 获取试投列表
     *
     * @return 活动列表
     */
    List<RspActivityDto> getNewActivityList() throws TuiaMediaException;

    /**
     * 获取默认列表
     *
     * @return 活动列表
     */
    List<RspActivityDto> getDefaultActivityList() throws TuiaMediaException;

    /**
     * 查询广告位下按相对排序的活动列表
     *
     * @param slotId
     * @return 活动列表
     */
    List<ActivitySortDto> getBySlot(Long slotId) throws TuiaMediaException;

    /**
     * 更新活动排序值
     * 
     * @param slotId
     * @param activityId
     * @param activityType
     * @param sort
     * @return Boolean
     */
    Boolean updateSort(Long slotId, Long activityId, Integer activityType, int sort) throws TuiaMediaException;
    
    /**
     * 更新活动排序值根据source
     * 
     * @param slotId
     * @param activityId
     * @param source
     * @param sort
     * @return Boolean
     */
    Boolean updateSortBySource(Long slotId, Long activityId, Integer source, int sort) throws TuiaMediaException;
}
