package cn.com.duiba.tuia.media.service;

import java.util.List;

import cn.com.duiba.tuia.media.api.dto.ActivitySpmDto;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;

/**
 * @author xuyenan
 * @createTime 2017/2/8
 */
public interface ActivitySpmService {

    /**
     * 活动根据SPM排序
     *
     * @param slotId 广告位ID
     * @param statType 统计维度
     * @return 排序的活动清单
     */
    List<ActivitySpmDto> getSlotSpm(Long slotId, Integer statType) throws TuiaMediaException;

    /**
     * 推啊活动Id列表
     * @param count
     * @return
     * @throws TuiaMediaException
     */
    List<Long> getTuiaActivityIdList(int count) throws TuiaMediaException;
}
