package cn.com.duiba.tuia.media.service;

import cn.com.duiba.goods.center.api.remoteservice.dto.ACGStockDto;
import cn.com.duiba.tuia.core.api.dto.AdvertDetailDto;
import cn.com.duiba.tuia.core.api.dto.AdvertDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspActivityAdvertDto;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;

import java.util.List;
import java.util.Map;

/**
 * @author xuyenan
 * @createTime 2017/1/12
 */
public interface AdvertService {

    /**
     * 查询广告基本信息.
     *
     * @param advertIds 广告ID
     * @return the advert base info by ids
     */
    Map<Long, AdvertDto> getAdvertListByIds(List<Long> advertIds) throws TuiaMediaException;

    /**
     * 查询广告详情.
     *
     * @param advertId 广告ID
     * @return the advert detail by id
     */
    AdvertDetailDto getAdvertDetailById(Long advertId);

    /**
     * 批量查询商品库存(当前库存和初始库存).
     *
     * @param couponId 优惠卷ID列表
     * @return the dubbo result< list< acg stock dto>>
     */
    ACGStockDto findGoodsStock(Long couponId);

    /**
     * 根据广告ID列表获取广告，有所有信息
     * 
     * @param ids 广告ID列表
     * @return 广告列表
     */
    List<RspActivityAdvertDto> getAdvertsByIds(List<Long> ids) throws TuiaMediaException;

}
